/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.config;

import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingPaths;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRoot;
import io.datarouter.clustersetting.service.ClusterSettingService;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.web.autoconfig.ConfigScanDto;
import io.datarouter.web.autoconfig.ConfigScanResponseTool;
import io.datarouter.web.email.DatarouterEmailService;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClusterSettingConfigScanner {
    @Inject
    private ClusterSettingService clusterSettingService;
    @Inject
    private DatarouterClusterSettingRoot clusterSettingsRoot;
    @Inject
    private DatarouterEmailService emailService;
    @Inject
    private DatarouterClusterSettingPaths paths;

    public ConfigScanDto checkForRedundantClusterSettings() {
        List settings = this.clusterSettingService.streamWithValidity(ClusterSettingValidity.REDUNDANT).map(ClusterSetting::getName).distinct().list();
        if (CollectionTool.isEmpty((Collection)settings)) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + settings.size() + " redundant cluster settings";
        return (ConfigScanDto)Scanner.of((Iterable)settings).map(this::makeBrowseSettingLink).listTo(links -> ConfigScanResponseTool.buildResponse((String)header, (List)links));
    }

    public ConfigScanDto checkForNonexistentClusterSettings() {
        List settings = this.clusterSettingService.streamWithValidity(ClusterSettingValidity.EXPIRED).map(ClusterSetting::getName).distinct().list();
        if (CollectionTool.isEmpty((Collection)settings)) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + settings.size() + " nonexistent cluster settings";
        return (ConfigScanDto)Scanner.of((Iterable)settings).map(this::makeBrowseSettingLink).listTo(links -> ConfigScanResponseTool.buildResponse((String)header, (List)links));
    }

    public ConfigScanDto checkForOldClusterSettings() {
        int oldSettingAlertThresholdDays = (Integer)this.clusterSettingsRoot.oldSettingAlertThresholdDays.get();
        List settings = this.clusterSettingService.streamWithValidity(ClusterSettingValidity.OLD).map(ClusterSetting::getName).distinct().list();
        if (CollectionTool.isEmpty((Collection)settings)) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + settings.size() + " cluster settings older than " + oldSettingAlertThresholdDays + " days";
        return (ConfigScanDto)Scanner.of((Iterable)settings).map(this::makeBrowseSettingLink).listTo(links -> ConfigScanResponseTool.buildResponse((String)header, (List)links));
    }

    private ContainerTag makeBrowseSettingLink(String setting) {
        String href = this.emailService.startLinkBuilder().withLocalPath(this.paths.datarouter.settings).withParam("submitAction", "browseSettings").withParam("name", setting).build();
        return this.makeLink(setting, href);
    }

    private ContainerTag makeLink(String text, String href) {
        return (ContainerTag)((ContainerTag)TagCreator.a((String)text).withHref(href)).withStyle("text-decoration:none;");
    }
}

