/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.service;

import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.cached.Cached;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CachedClusterSettingNames
extends Cached<TreeSet<String>> {
    private final SettingRoot.SettingRootFinder settingRootFinder;

    @Inject
    public CachedClusterSettingNames(SettingRoot.SettingRootFinder settingRootFinder) {
        super(1L, TimeUnit.MINUTES);
        this.settingRootFinder = settingRootFinder;
    }

    protected TreeSet<String> reload() {
        return this.settingRootFinder.getRootNodesSortedByShortName().stream().flatMap(this::getSettingsNames).collect(Collectors.toCollection(TreeSet::new));
    }

    private Stream<String> getSettingsNames(SettingNode settingNode) {
        String currentSettingName = settingNode.getName();
        String trimmmedSettingName = currentSettingName.substring(0, currentSettingName.length() - 1);
        Stream<String> currentNodesSettingsNames = settingNode.getSettings().values().stream().map(CachedSetting::getName);
        Stream childrenNodesSettingsNames = settingNode.getChildren().values().stream().flatMap(this::getSettingsNames);
        return Stream.of(Stream.of(trimmmedSettingName), currentNodesSettingsNames, childrenNodesSettingsNames).flatMap(Function.identity());
    }
}

