/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.service;

import io.datarouter.clustersetting.ClusterSettingFinder;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRoot;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.clustersetting.storage.clustersetting.DatarouterClusterSettingDao;
import io.datarouter.clustersetting.storage.clustersettinglog.DatarouterClusterSettingLogDao;
import io.datarouter.clustersetting.web.dto.ClusterSettingAndValidityJspDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.storage.util.KeyRangeTool;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Range;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClusterSettingService {
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterClusterSettingRoot clusterSettingRoot;
    @Inject
    private DatarouterClusterSettingDao clusterSettingDao;
    @Inject
    private DatarouterClusterSettingLogDao clusterSettingLogDao;
    @Inject
    private DatarouterWebappInstanceDao webappInstanceDao;
    @Inject
    private ClusterSettingFinder clusterSettingFinder;
    @Inject
    private SettingRoot.SettingRootFinder settingRootFinder;
    @Inject
    private ServerTypes serverTypes;

    public <T> T getSettingValueForWebappInstance(CachedSetting<T> memorySetting, WebappInstance webappInstance) {
        List<ClusterSetting> settingsWithName = this.clusterSettingFinder.getAllSettingsWithName(memorySetting.getName());
        List<ClusterSetting> settingsForWebappInstance = ClusterSetting.filterForWebappInstance(settingsWithName, webappInstance);
        Optional<ClusterSetting> mostSpecificSetting = ClusterSetting.getMostSpecificSetting(settingsForWebappInstance);
        if (mostSpecificSetting.isPresent()) {
            return ClusterSetting.getTypedValueOrUseDefaultFrom(mostSpecificSetting, memorySetting);
        }
        DatarouterEnvironmentType environmentType = new DatarouterEnvironmentType(this.datarouterProperties.getEnvironmentType());
        DefaultSettingValue defaultSettingValue = memorySetting.getDefaultSettingValue();
        ServerType webAppInstanceServerType = this.serverTypes.fromPersistentString(webappInstance.getServerType());
        String serverName = this.datarouterProperties.getServerName();
        String environmentName = this.datarouterProperties.getEnvironment();
        return (T)defaultSettingValue.getValue(environmentType, environmentName, webAppInstanceServerType, serverName);
    }

    public <T> Map<WebappInstance, T> getSettingValueByWebappInstance(CachedSetting<T> memorySetting) {
        return (Map)this.webappInstanceDao.scan().collect(Collectors.toMap(Function.identity(), instance -> this.getSettingValueForWebappInstance(memorySetting, (WebappInstance)instance)));
    }

    public Scanner<ClusterSetting> streamWithValidity(ClusterSettingValidity validity) {
        Map serverTypeByServerName = this.webappInstanceDao.getServerTypeByServerName();
        return this.clusterSettingDao.scan().exclude(setting -> setting.getName().startsWith("datarouter")).include(setting -> this.getValidity(serverTypeByServerName, (ClusterSetting)((Object)setting)) == validity);
    }

    public Scanner<ClusterSettingAndValidityJspDto> scanClusterSettingAndValidityWithPrefix(String prefix) {
        Map serverTypeByServerName = this.webappInstanceDao.getServerTypeByServerName();
        Range range = prefix == null ? Range.everything() : KeyRangeTool.forPrefixWithWildcard((String)prefix, value -> new ClusterSettingKey(value, null, null, null, null));
        return this.clusterSettingDao.scan((Range<ClusterSettingKey>)range).map(setting -> new ClusterSettingAndValidityJspDto((ClusterSetting)((Object)setting), this.getValidity(serverTypeByServerName, (ClusterSetting)((Object)setting))));
    }

    private ClusterSettingValidity getValidity(Map<String, String> serverTypeByServerName, ClusterSetting databeanSetting) {
        Object databeanValue;
        String currentServerName;
        ServerType currentServerType;
        String environmentName;
        String name = databeanSetting.getName();
        ClusterSettingScope scope = databeanSetting.getScope();
        if (!this.settingRootFinder.isRecognized(name)) {
            return ClusterSettingValidity.UNKNOWN;
        }
        Optional memorySetting = this.settingRootFinder.getSettingByName(name);
        if (memorySetting.isEmpty()) {
            return ClusterSettingValidity.EXPIRED;
        }
        String serverType = null;
        String serverName = databeanSetting.getServerName();
        if (scope == ClusterSettingScope.SERVER_TYPE) {
            serverType = databeanSetting.getServerType();
        } else if (scope == ClusterSettingScope.SERVER_NAME) {
            serverType = serverTypeByServerName.get(serverName);
        }
        if (scope == ClusterSettingScope.SERVER_NAME && StringTool.isEmpty((String)serverType)) {
            return ClusterSettingValidity.INVALID_SERVER_NAME;
        }
        DatarouterEnvironmentType environmentType = new DatarouterEnvironmentType(this.datarouterProperties.getEnvironmentType());
        DefaultSettingValue defaultSettingValue = ((CachedSetting)memorySetting.get()).getDefaultSettingValue();
        Object defaultValue = defaultSettingValue.getValue(environmentType, environmentName = this.datarouterProperties.getEnvironment(), currentServerType = this.datarouterProperties.getServerType(), currentServerName = this.datarouterProperties.getServerName());
        boolean redundant = Objects.equals(defaultValue, databeanValue = databeanSetting.getTypedValue((Setting)memorySetting.get()));
        if (redundant) {
            return ClusterSettingValidity.REDUNDANT;
        }
        if (scope != ClusterSettingScope.APPLICATION) {
            int oldSettingAlertThresholdDays = (Integer)this.clusterSettingRoot.oldSettingAlertThresholdDays.get();
            Set settingsExcludedFromOldSettingsAlert = (Set)this.clusterSettingRoot.settingsExcludedFromOldSettingsAlert.get();
            if (settingsExcludedFromOldSettingsAlert.stream().noneMatch(setting -> StringTool.containsCaseInsensitive((String)name, (String)setting)) && this.clusterSettingLogDao.isOldDatabaseSetting(databeanSetting, oldSettingAlertThresholdDays)) {
                return ClusterSettingValidity.OLD;
            }
        }
        return ClusterSettingValidity.VALID;
    }

    public Optional<ClusterSetting> getSettingByName(String name) {
        ClusterSettingKey prefix = new ClusterSettingKey(name, null, null, null, null);
        return this.clusterSettingDao.scanWithPrefix(prefix).findFirst();
    }

    public String checkValidJobSettingOnAnyServerType(CachedSetting<Boolean> setting) {
        Map<WebappInstance, Boolean> allSettings = this.getSettingValueByWebappInstance(setting);
        Optional<Boolean> validSetting = allSettings.values().stream().filter(BooleanTool::isTrue).findFirst();
        if (validSetting.isPresent()) {
            return "";
        }
        return String.valueOf(setting.getName()) + " is not enabled on at least one server of any type";
    }

    public Integer checkValidJobletSettingOnAnyServerType(CachedSetting<Integer> setting) {
        Map<WebappInstance, Integer> allSettings = this.getSettingValueByWebappInstance(setting);
        return allSettings.values().stream().filter(value -> value != 0).findFirst().orElse(-1);
    }
}

