/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.storage.clustersetting;

import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.ClusterSettingScopeComparator;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.storage.setting.Setting;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClusterSetting
extends BaseDatabean<ClusterSettingKey, ClusterSetting> {
    private String value;

    public ClusterSetting() {
        super((PrimaryKey)new ClusterSettingKey(null, null, null, null, null));
    }

    public ClusterSetting(ClusterSettingKey key, String value) {
        super((PrimaryKey)key);
        this.value = value;
    }

    public ClusterSetting(String name, ClusterSettingScope scope, String serverType, String serverName, String application, String value) {
        super((PrimaryKey)new ClusterSettingKey(name, scope, serverType, serverName, application));
        this.value = value;
    }

    public Class<ClusterSettingKey> getKeyClass() {
        return ClusterSettingKey.class;
    }

    public static Optional<ClusterSetting> getMostSpecificSettingForWebappInstance(List<ClusterSetting> settings, WebappInstance webappInstance) {
        List<ClusterSetting> settingsForWebappInstance = ClusterSetting.filterForWebappInstance(settings, webappInstance);
        return ClusterSetting.getMostSpecificSetting(settingsForWebappInstance);
    }

    public static List<ClusterSetting> filterForWebappInstance(List<ClusterSetting> settings, WebappInstance webappInstance) {
        return settings.stream().filter(setting -> ((ClusterSettingKey)setting.getKey()).appliesToWebappInstance(webappInstance)).collect(Collectors.toList());
    }

    public static Optional<ClusterSetting> getMostSpecificSetting(List<ClusterSetting> settings) {
        return settings.isEmpty() ? Optional.empty() : Optional.of(Collections.min(settings, new ClusterSettingScopeComparator()));
    }

    public static <T> T getTypedValueOrUseDefaultFrom(Optional<ClusterSetting> clusterSetting, Setting<T> settingForTypeAndDefault) {
        return (T)clusterSetting.map(setting2 -> setting2.getTypedValue(settingForTypeAndDefault)).orElse(settingForTypeAndDefault.getDefaultValue());
    }

    public <T> T getTypedValue(Setting<T> parser) {
        return (T)parser.parseStringValue(this.value);
    }

    public String toString() {
        return String.valueOf(((ClusterSettingKey)this.getKey()).toString()) + ":" + this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ClusterSettingScope getScope() {
        return ((ClusterSettingKey)this.getKey()).getScope();
    }

    public void setScope(ClusterSettingScope scope) {
        ((ClusterSettingKey)this.getKey()).setScope(scope);
    }

    public String getServerType() {
        return ((ClusterSettingKey)this.getKey()).getServerType();
    }

    public void setServerType(String serverType) {
        ((ClusterSettingKey)this.getKey()).setServerType(serverType);
    }

    public String getServerName() {
        return ((ClusterSettingKey)this.getKey()).getServerName();
    }

    public void setServerName(String serverName) {
        ((ClusterSettingKey)this.getKey()).setServerName(serverName);
    }

    public String getApplication() {
        return ((ClusterSettingKey)this.getKey()).getApplication();
    }

    public void setApplication(String application) {
        ((ClusterSettingKey)this.getKey()).setApplication(application);
    }

    public String getName() {
        return ((ClusterSettingKey)this.getKey()).getName();
    }

    public void setName(String name) {
        ((ClusterSettingKey)this.getKey()).setName(name);
    }

    public static class ClusterSettingFielder
    extends BaseDatabeanFielder<ClusterSettingKey, ClusterSetting> {
        public ClusterSettingFielder() {
            super(ClusterSettingKey.class);
        }

        public List<Field<?>> getNonKeyFields(ClusterSetting databean) {
            return Arrays.asList(new StringField(FieldKeys.value, databean.value));
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey value = new StringFieldKey("value").withSize(65535);
    }
}

