/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.storage.clustersetting;

import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.SettinglessNodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClusterSettingDao
extends BaseDao {
    private final SortedMapStorage<ClusterSettingKey, ClusterSetting> node;

    @Inject
    public DatarouterClusterSettingDao(Datarouter datarouter, SettinglessNodeFactory settinglessNodeFactory, DatarouterClusterSettingDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage)settinglessNodeFactory.create(params.clientId, ClusterSetting::new, ClusterSetting.ClusterSettingFielder::new).buildAndRegister();
    }

    public Scanner<ClusterSetting> scan() {
        return this.node.scan();
    }

    public Scanner<ClusterSetting> scan(Range<ClusterSettingKey> range) {
        return this.node.scan(range);
    }

    public Scanner<ClusterSetting> scanWithPrefix(ClusterSettingKey prefix) {
        return this.node.scanWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<ClusterSettingKey> scanKeysWithPrefix(ClusterSettingKey prefix) {
        return this.node.scanKeysWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<ClusterSettingKey> scanKeysWithPrefixes(Collection<ClusterSettingKey> prefixes) {
        return this.node.scanKeysWithPrefixes(prefixes);
    }

    public void put(ClusterSetting databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(Collection<ClusterSetting> databeans) {
        this.node.putMulti(databeans);
    }

    public ClusterSetting get(ClusterSettingKey key) {
        return (ClusterSetting)this.node.get((PrimaryKey)key);
    }

    public List<ClusterSetting> getMulti(Collection<ClusterSettingKey> keys) {
        return this.node.getMulti(keys);
    }

    public void delete(ClusterSettingKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public void deleteMulti(Collection<ClusterSettingKey> keys) {
        this.node.deleteMulti(keys);
    }

    public boolean exists(ClusterSettingKey key) {
        return this.node.exists((PrimaryKey)key);
    }

    public Optional<ClusterSetting> find(ClusterSettingKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public static class DatarouterClusterSettingDaoParams
    extends BaseDaoParams {
        public DatarouterClusterSettingDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

