/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.storage.clustersettinglog;

import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLog;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogByReversedCreatedMsKey;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.FieldlessIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.IndexingNodeFactory;
import io.datarouter.storage.node.factory.SettinglessNodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.node.op.index.IndexReader;
import io.datarouter.util.DateTool;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClusterSettingLogDao
extends BaseDao {
    private final IndexedSortedMapStorage.IndexedSortedMapStorageNode<ClusterSettingLogKey, ClusterSettingLog, ClusterSettingLog.ClusterSettingLogFielder> clusterSettingLog;
    private final IndexReader<ClusterSettingLogKey, ClusterSettingLog, ClusterSettingLogByReversedCreatedMsKey, FieldlessIndexEntry<ClusterSettingLogByReversedCreatedMsKey, ClusterSettingLogKey, ClusterSettingLog>> clusterSettingLogByReversedCreatedMs;

    @Inject
    public DatarouterClusterSettingLogDao(Datarouter datarouter, SettinglessNodeFactory settinglessNodeFactory, DatarouterClusterSettingLogDaoParams params, IndexingNodeFactory indexingNodeFactory) {
        super(datarouter);
        this.clusterSettingLog = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)settinglessNodeFactory.create(params.clientId, ClusterSettingLog::new, ClusterSettingLog.ClusterSettingLogFielder::new).build();
        this.clusterSettingLogByReversedCreatedMs = indexingNodeFactory.createKeyOnlyManagedIndex(ClusterSettingLogByReversedCreatedMsKey.class, this.clusterSettingLog).build();
        datarouter.register(this.clusterSettingLog);
    }

    public void put(ClusterSettingLog databean) {
        this.clusterSettingLog.put((Databean)databean);
    }

    public void putMulti(Collection<ClusterSettingLog> databeans) {
        this.clusterSettingLog.putMulti(databeans);
    }

    public Scanner<ClusterSettingLog> scanWithPrefix(ClusterSettingLogKey prefix) {
        return this.clusterSettingLog.scanWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<ClusterSettingLog> scanWithPrefixes(Collection<ClusterSettingLogKey> prefixes) {
        return this.clusterSettingLog.scanWithPrefixes(prefixes);
    }

    public Scanner<ClusterSettingLog> scanByReversedCreatedMs(Range<ClusterSettingLogByReversedCreatedMsKey> range, int limit) {
        return this.clusterSettingLogByReversedCreatedMs.scanDatabeans(range, new Config().setLimit(Integer.valueOf(limit)));
    }

    public boolean isOldDatabaseSetting(ClusterSetting databeanSetting, int numOfDays) {
        Date maxSettingAge = DateTool.getDaysAgo((int)numOfDays);
        return this.clusterSettingLog.scanKeysWithPrefix((PrimaryKey)ClusterSettingLogKey.createPrefix(databeanSetting.getName()), new Config().setLimit(Integer.valueOf(1))).findFirst().map(ClusterSettingLogKey::getCreated).map(created -> created.compareTo(maxSettingAge) < 0).orElse(false);
    }

    public static class DatarouterClusterSettingLogDaoParams
    extends BaseDaoParams {
        public DatarouterClusterSettingLogDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

