/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.web.dto;

import io.datarouter.clustersetting.ClusterSettingLogAction;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLog;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogKey;
import io.datarouter.util.enums.StringEnum;
import io.datarouter.util.string.StringTool;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ClusterSettingLogJspDto {
    private static final String TABLE_CELL_DEFAULT = "&nbsp;";
    private final String name;
    private final Date created;
    private final ClusterSettingScope scope;
    private final String serverType;
    private final String serverName;
    private final String application;
    private final String value;
    private final ClusterSettingLogAction action;
    private final String changedBy;
    private final String comment;

    public ClusterSettingLogJspDto(ClusterSettingLog clusterSettingLog) {
        this.name = ((ClusterSettingLogKey)clusterSettingLog.getKey()).getName();
        this.created = ((ClusterSettingLogKey)clusterSettingLog.getKey()).getCreated();
        this.scope = clusterSettingLog.getScope();
        this.serverType = clusterSettingLog.getServerType();
        this.serverName = clusterSettingLog.getServerName();
        this.application = clusterSettingLog.getApplication();
        this.value = clusterSettingLog.getValue();
        this.action = clusterSettingLog.getAction();
        this.changedBy = clusterSettingLog.getChangedBy();
        this.comment = clusterSettingLog.getComment();
    }

    public String getName() {
        return this.name;
    }

    public String[] getNameParts() {
        return this.name.split("\\.");
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreatedIsoLocalDateTime() {
        return ZonedDateTime.ofInstant(this.getCreated().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public ClusterSettingScope getScope() {
        return this.scope;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getApplication() {
        return this.application;
    }

    public String getValue() {
        return this.value;
    }

    public ClusterSettingLogAction getAction() {
        return this.action;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String getComment() {
        return this.comment;
    }

    public String getHtmlSafeScope() {
        return this.htmlSafe(this.scope);
    }

    public String getHtmlSafeServerType() {
        return this.htmlSafe(this.serverType);
    }

    public String getHtmlSafeServerName() {
        return this.htmlSafe(this.serverName);
    }

    public String getHtmlSafeApplication() {
        return this.htmlSafe(this.application);
    }

    public String getHtmlSafeValue() {
        return this.htmlSafe(this.value);
    }

    public String getHtmlSafeAction() {
        return this.htmlSafe(this.action);
    }

    public String getHtmlSafeChangedBy() {
        return this.htmlSafe(this.changedBy);
    }

    public String getHtmlSafeComment() {
        return this.htmlSafe(this.comment);
    }

    private String htmlSafe(String str) {
        return StringTool.isNullOrEmpty((String)str) ? TABLE_CELL_DEFAULT : str;
    }

    private <T extends StringEnum<T>> String htmlSafe(T stringEnum) {
        return stringEnum.getPersistentString() == null ? TABLE_CELL_DEFAULT : stringEnum.toString();
    }
}

