/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.web.dto;

import io.datarouter.clustersetting.web.dto.ClusterSettingDefaultJspDto;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.cached.CachedSetting;
import java.util.ArrayList;
import java.util.List;

public class SettingJspDto<T> {
    private final String name;
    private final Boolean hasRedundantCustomValue;
    private final Boolean hasCustomValue;
    private final T value;
    private final T defaultValue;
    private final List<ClusterSettingDefaultJspDto> codeOverrides;

    public SettingJspDto(CachedSetting<T> setting) {
        this.name = setting.getName();
        this.hasRedundantCustomValue = setting.getHasRedundantCustomValue();
        this.hasCustomValue = setting.getHasCustomValue();
        this.value = setting.get();
        this.defaultValue = setting.getDefaultValue();
        this.codeOverrides = this.toDefaults(setting.getDefaultSettingValue());
    }

    private List<ClusterSettingDefaultJspDto> toDefaults(DefaultSettingValue<?> defaults) {
        ArrayList<ClusterSettingDefaultJspDto> dtos = new ArrayList<ClusterSettingDefaultJspDto>();
        defaults.getValueByEnvironmentType().forEach((profile, value) -> {
            String profileString = profile.getPersistentString();
            dtos.add(new ClusterSettingDefaultJspDto(false, profileString, null, null, null, value));
        });
        defaults.getValueByServerTypeByEnvironmentType().forEach((profile, defaultByServerType) -> {
            String profileString = profile.getPersistentString();
            defaultByServerType.forEach((serverType, value) -> {
                boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, profileString, null, (String)serverType, null, value));
            });
        });
        defaults.getValueByServerNameByEnvironmentType().forEach((profile, defaultByServerName) -> {
            String profileString = profile.getPersistentString();
            defaultByServerName.forEach((serverName, value) -> {
                boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, profileString, null, null, (String)serverName, value));
            });
        });
        defaults.getValueByEnvironmentNameByEnvironmentType().forEach((profile, defaultByEnvironment) -> {
            String profileString = profile.getPersistentString();
            defaultByEnvironment.forEach((environment, value) -> {
                boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, profileString, (String)environment, null, null, value));
            });
        });
        return dtos;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getHasRedundantCustomValue() {
        return this.hasRedundantCustomValue;
    }

    public Boolean getHasCustomValue() {
        return this.hasCustomValue;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public List<ClusterSettingDefaultJspDto> getCodeOverrides() {
        return this.codeOverrides;
    }
}

