/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.clustersetting.ClusterSettingScopeComparator;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.setting.Setting;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ClusterSettingComparisonTool {
    public static Optional<ClusterSetting> getMostSpecificSettingForWebappInstance(List<ClusterSetting> settings, WebappInstance webappInstance) {
        List<ClusterSetting> settingsForWebappInstance = ClusterSettingComparisonTool.appliesToWebappInstance(settings, webappInstance);
        return ClusterSettingComparisonTool.getMostSpecificSetting(settingsForWebappInstance);
    }

    public static Optional<ClusterSetting> getMostSpecificSetting(List<ClusterSetting> settings) {
        return settings.isEmpty() ? Optional.empty() : Optional.of(Collections.min(settings, new ClusterSettingScopeComparator()));
    }

    public static List<ClusterSetting> appliesToWebappInstance(List<ClusterSetting> settings, WebappInstance webappInstance) {
        return Scanner.of(settings).include(setting -> ((ClusterSettingKey)setting.getKey()).appliesToWebappInstance(webappInstance)).list();
    }

    public static <T> T getTypedValueOrUseDefaultFrom(Optional<ClusterSetting> clusterSetting, Setting<T> settingForTypeAndDefault) {
        return (T)clusterSetting.map(setting2 -> setting2.getTypedValue(settingForTypeAndDefault)).orElseGet(() -> settingForTypeAndDefault.getDefaultValue());
    }

    public static boolean equal(ClusterSetting first, ClusterSetting second) {
        if (ObjectTool.bothNull((Object)((Object)first), (Object)((Object)second))) {
            return true;
        }
        if (ObjectTool.isOneNullButNotTheOther((Object)((Object)first), (Object)((Object)second))) {
            return false;
        }
        return first.getName().equals(second.getName()) && first.getScope() == second.getScope() && first.getServerType().equals(second.getServerType()) && first.getServerName().equals(second.getServerName()) && first.getValue().equals(second.getValue());
    }
}

