/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.clustersetting.ClusterSettingComparisonTool;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.clustersetting.storage.clustersetting.DatarouterClusterSettingDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.string.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClusterSettingFinder
implements SettingFinder {
    public static final String EMPTY_STRING = "";
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterClusterSettingDao clusterSettingDao;
    private final List<CachedSetting<?>> allCachedSettings = new ArrayList();
    private Boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCachedSetting(CachedSetting<?> setting) {
        Boolean bl = this.started;
        synchronized (bl) {
            if (this.started.booleanValue()) {
                ClusterSettingFinder.validateSetting(setting);
            } else {
                this.allCachedSettings.add(setting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAllCachedSettings() {
        Boolean bl = this.started;
        synchronized (bl) {
            if (this.started.booleanValue()) {
                return;
            }
            this.started = true;
            this.allCachedSettings.forEach(ClusterSettingFinder::validateSetting);
            this.allCachedSettings.clear();
        }
    }

    private static void validateSetting(CachedSetting<?> setting) {
        setting.validateAllCustomValuesCanBeParsed();
    }

    public String getEnvironmentType() {
        return this.datarouterProperties.getEnvironmentType();
    }

    public String getEnvironmentName() {
        return this.datarouterProperties.getEnvironment();
    }

    public ServerType getServerType() {
        return this.datarouterProperties.getServerType();
    }

    public String getServerName() {
        return this.datarouterProperties.getServerName();
    }

    public Optional<String> getSettingValue(String name) {
        List<ClusterSettingKey> keys = this.generateKeysForSelection(name);
        List<ClusterSetting> settings = this.clusterSettingDao.getMultiFromCache(keys);
        return ClusterSettingComparisonTool.getMostSpecificSetting(settings).map(ClusterSetting::getValue);
    }

    public List<String> getAllCustomSettingValues(String name) {
        return Scanner.of(this.getAllSettingsWithName(name)).map(ClusterSetting::getValue).list();
    }

    public List<ClusterSetting> getAllSettingsWithName(String name) {
        ClusterSettingKey prefix = new ClusterSettingKey(name, null, null, null);
        return this.clusterSettingDao.scanWithPrefix(prefix).list();
    }

    private List<ClusterSettingKey> generateKeysForSelection(String name) {
        ClusterSettingKey serverNameSetting;
        ArrayList<ClusterSettingKey> keys = new ArrayList<ClusterSettingKey>();
        keys.add(new ClusterSettingKey(name, ClusterSettingScope.DEFAULT_SCOPE, ServerType.UNKNOWN.getPersistentString(), EMPTY_STRING));
        ClusterSettingKey serverTypeSetting = this.getKeyForServerType(name);
        if (serverTypeSetting != null) {
            keys.add(serverTypeSetting);
        }
        if ((serverNameSetting = this.getKeyForServerName(name)) != null) {
            keys.add(serverNameSetting);
        }
        return keys;
    }

    private ClusterSettingKey getKeyForServerType(String name) {
        ServerType serverType = this.datarouterProperties.getServerType();
        if (serverType == null || serverType.getPersistentString().equals(ServerType.UNKNOWN.getPersistentString())) {
            return null;
        }
        return new ClusterSettingKey(name, ClusterSettingScope.SERVER_TYPE, serverType.getPersistentString(), EMPTY_STRING);
    }

    private ClusterSettingKey getKeyForServerName(String name) {
        String serverName = this.datarouterProperties.getServerName();
        if (StringTool.isEmpty((String)serverName)) {
            return null;
        }
        return new ClusterSettingKey(name, ClusterSettingScope.SERVER_NAME, ServerType.UNKNOWN.getPersistentString(), serverName);
    }
}

