/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.PersistentString;
import io.datarouter.util.enums.StringEnum;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.string.StringTool;

public enum ClusterSettingScope implements StringEnum<ClusterSettingScope>
{
    DEFAULT_SCOPE("defaultScope", 1000),
    SERVER_TYPE("serverType", 100),
    SERVER_NAME("serverName", 10);

    private final String persistentString;
    private final int specificity;

    private ClusterSettingScope(String persistentString, int specificity) {
        this.persistentString = persistentString;
        this.specificity = specificity;
    }

    public String getPersistentString() {
        return this.persistentString;
    }

    public static ClusterSettingScope fromPersistentStringStatic(String str) {
        return (ClusterSettingScope)DatarouterEnumTool.getEnumFromString((PersistentString[])ClusterSettingScope.values(), (String)str, null);
    }

    public ClusterSettingScope fromPersistentString(String str) {
        return ClusterSettingScope.fromPersistentStringStatic(str);
    }

    public static ClusterSettingScope fromParams(ServerType serverType, String serverName) {
        return ClusterSettingScope.fromParams(serverType.getPersistentString(), serverName);
    }

    public static ClusterSettingScope fromParams(String serverTypePersistentString, String serverName) {
        if (StringTool.notEmpty((String)serverName)) {
            return SERVER_NAME;
        }
        if (ObjectTool.notEquals((Object)ServerType.UNKNOWN.getPersistentString(), (Object)serverTypePersistentString) && ObjectTool.notEquals((Object)ServerType.ALL.getPersistentString(), (Object)serverTypePersistentString)) {
            return SERVER_TYPE;
        }
        return DEFAULT_SCOPE;
    }

    public int getSpecificity() {
        return this.specificity;
    }
}

