/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.storage.servertype.ServerType;

public class ClusterSettingScopeValue
implements Comparable<ClusterSettingScopeValue> {
    private final ClusterSettingScope scope;
    private final String value;
    private final String displayString;
    private static final String EMPTY_STRING = "";

    public ClusterSettingScopeValue(ClusterSettingKey setting) {
        this.scope = setting.getScope();
        switch (this.scope) {
            case DEFAULT_SCOPE: {
                this.value = EMPTY_STRING;
                this.displayString = "Default Scope";
                break;
            }
            case SERVER_TYPE: {
                this.value = setting.getServerType();
                this.displayString = "Server Type: " + setting.getServerType();
                break;
            }
            case SERVER_NAME: {
                this.value = setting.getServerName();
                this.displayString = "Server Name: " + setting.getServerName();
                break;
            }
            default: {
                throw new RuntimeException("Failed to construct ClusterSettingScopeValue from ClusterSettingKey: " + setting.toString());
            }
        }
    }

    @Override
    public int compareTo(ClusterSettingScopeValue other) {
        int scopeCompare = this.scope.compareTo(other.scope);
        return scopeCompare != 0 ? scopeCompare : this.value.compareTo(other.value);
    }

    public String getPersistentString() {
        return String.valueOf(this.scope.getPersistentString()) + '_' + this.value;
    }

    public static ClusterSettingScopeValue parse(String persistentString) {
        if (persistentString == null) {
            return null;
        }
        String[] parts = persistentString.split("_", 2);
        if (parts.length == 0) {
            return null;
        }
        ClusterSettingScope scope = ClusterSettingScope.fromPersistentStringStatic(parts[0]);
        switch (scope) {
            case DEFAULT_SCOPE: 
            case SERVER_TYPE: {
                return new ClusterSettingScopeValue(new ClusterSettingKey(null, scope, parts[1], null));
            }
            case SERVER_NAME: {
                return new ClusterSettingScopeValue(new ClusterSettingKey(null, scope, null, parts[1]));
            }
        }
        throw new RuntimeException("Failed to parse ClusterSettingScopeValue from string: " + persistentString);
    }

    public ClusterSettingKey toClusterSettingKey(String settingName) {
        switch (this.scope) {
            case DEFAULT_SCOPE: {
                return new ClusterSettingKey(settingName, this.scope, ServerType.UNKNOWN.getPersistentString(), EMPTY_STRING);
            }
            case SERVER_TYPE: {
                return new ClusterSettingKey(settingName, this.scope, this.value, EMPTY_STRING);
            }
            case SERVER_NAME: {
                return new ClusterSettingKey(settingName, this.scope, ServerType.UNKNOWN.getPersistentString(), this.value);
            }
        }
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }
}

