/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.config;

import io.datarouter.clustersetting.ClusterSettingScopeComparator;
import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingPaths;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRoot;
import io.datarouter.clustersetting.service.ClusterSettingService;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.autoconfig.ConfigScanDto;
import io.datarouter.web.autoconfig.ConfigScanResponseTool;
import io.datarouter.web.email.DatarouterEmailService;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClusterSettingConfigScanner {
    @Inject
    private ClusterSettingService clusterSettingService;
    @Inject
    private DatarouterClusterSettingRoot clusterSettingsRoot;
    @Inject
    private DatarouterEmailService emailService;
    @Inject
    private DatarouterClusterSettingPaths paths;

    public ConfigScanDto checkForRedundantClusterSettings() {
        return this.buildConfigScanResponse(this.clusterSettingService.scanAllWebappInstancesWithRedundantValidity(), ClusterSettingValidity.REDUNDANT, ", redundant on all webapp instances");
    }

    public ConfigScanDto checkForNonexistentClusterSettings() {
        return this.scanClusterSettingWithValidity(ClusterSettingValidity.EXPIRED, "");
    }

    public ConfigScanDto checkForInvalidServerTypeClusterSettings() {
        return this.scanClusterSettingWithValidity(ClusterSettingValidity.INVALID_SERVER_TYPE, "");
    }

    public ConfigScanDto checkForOldClusterSettings() {
        String additionalMessage = ", older than the alert threshold of " + this.clusterSettingsRoot.oldSettingAlertThresholdDays.get() + " days";
        return this.scanClusterSettingWithValidity(ClusterSettingValidity.OLD, additionalMessage);
    }

    private ConfigScanDto scanClusterSettingWithValidity(ClusterSettingValidity validity, String additionalMessage) {
        return this.buildConfigScanResponse(this.clusterSettingService.scanWithValidity(validity), validity, additionalMessage);
    }

    private ConfigScanDto buildConfigScanResponse(Scanner<ClusterSetting> settingsScanner, ClusterSettingValidity validity, String additionalMessage) {
        List clusterSettings = settingsScanner.distinctBy(BaseDatabean::getKey).sorted(Comparator.comparing(ClusterSetting::getName).thenComparing(new ClusterSettingScopeComparator().reversed())).list();
        if (clusterSettings.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        int size = clusterSettings.size();
        String header = "Found " + size + " " + validity.persistentString + " cluster setting" + (size > 1 ? "s" : "") + (additionalMessage.isEmpty() ? "" : additionalMessage);
        ContainerTag settingsTable = this.makeBrowserSettingTable(clusterSettings, header);
        return ConfigScanResponseTool.buildResponse((ContainerTag)settingsTable);
    }

    private ContainerTag makeBrowserSettingTable(List<ClusterSetting> settings, String header) {
        ContainerTag table = new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Name", row -> this.makeSettingLink(row.getName()))).withColumn("Scope", row -> row.getScope().getPersistentString()).withColumn("Server Type", ClusterSetting::getServerType).withColumn("Server Name", ClusterSetting::getServerName).withColumn("Value", ClusterSetting::getValue).build(settings);
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)header), table});
    }

    public ContainerTag makeSettingLink(String settingName) {
        String href = this.emailService.startLinkBuilder().withLocalPath(this.paths.datarouter.settings).withParam("submitAction", "browseSettings").withParam("name", settingName).build();
        return (ContainerTag)((ContainerTag)TagCreator.a((String)settingName).withHref(href)).withStyle("text-decoration:none;");
    }
}

