/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.config;

import io.datarouter.clustersetting.ClusterSettingFinder;
import io.datarouter.clustersetting.config.DatarouterClusterSettingPaths;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRoot;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRouteSet;
import io.datarouter.clustersetting.config.DatarouterClusterSettingTriggerGroup;
import io.datarouter.clustersetting.listener.SettingNodeValidationAppListener;
import io.datarouter.clustersetting.service.ClusterSettingDailyDigest;
import io.datarouter.clustersetting.storage.clustersetting.DatarouterClusterSettingDao;
import io.datarouter.clustersetting.storage.clustersettinglog.DatarouterClusterSettingLogDao;
import io.datarouter.job.config.BaseJobPlugin;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.List;

public class DatarouterClusterSettingPlugin
extends BaseJobPlugin {
    private DatarouterClusterSettingPlugin(DatarouterClusterSettingDaoModule daosModuleBuilder) {
        this.addSettingRoot(DatarouterClusterSettingRoot.class);
        this.addRouteSet(DatarouterClusterSettingRouteSet.class);
        this.addAppListener(SettingNodeValidationAppListener.class);
        this.addTriggerGroup(DatarouterClusterSettingTriggerGroup.class);
        String browseSettings = String.valueOf(new DatarouterClusterSettingPaths().datarouter.settings.toSlashedString()) + "?submitAction=browseSettings";
        String settingLogs = String.valueOf(new DatarouterClusterSettingPaths().datarouter.settings.toSlashedString()) + "?submitAction=logsForAll";
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.SETTINGS, browseSettings, "Browse Settings");
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.SETTINGS, settingLogs, "Setting logs");
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.SETTINGS, new DatarouterClusterSettingPaths().datarouter.settings, "Custom Settings");
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterGithubDocLink("datarouter-cluster-setting");
        this.addDailyDigest(ClusterSettingDailyDigest.class);
    }

    public String getName() {
        return "DatarouterClusterSetting";
    }

    protected void configure() {
        this.bindActual(SettingFinder.class, ClusterSettingFinder.class);
    }

    public static class DatarouterClusterSettingDaoModule
    extends DaosModuleBuilder {
        private final ClientId datarouterClusterSettingClientId;
        private final ClientId datarouterClusterSettingLogClientId;

        public DatarouterClusterSettingDaoModule(ClientId datarouterClusterSettingClientId, ClientId datarouterClusterSettingLogClientId) {
            this.datarouterClusterSettingClientId = datarouterClusterSettingClientId;
            this.datarouterClusterSettingLogClientId = datarouterClusterSettingLogClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterClusterSettingDao.class, DatarouterClusterSettingLogDao.class);
        }

        public void configure() {
            this.bind(DatarouterClusterSettingDao.DatarouterClusterSettingDaoParams.class).toInstance((Object)new DatarouterClusterSettingDao.DatarouterClusterSettingDaoParams(this.datarouterClusterSettingClientId));
            this.bind(DatarouterClusterSettingLogDao.DatarouterClusterSettingLogDaoParams.class).toInstance((Object)new DatarouterClusterSettingLogDao.DatarouterClusterSettingLogDaoParams(this.datarouterClusterSettingLogClientId));
        }
    }

    public static class DatarouterClusterSettingPluginBuilder {
        private final ClientId defaultClientId;

        public DatarouterClusterSettingPluginBuilder(ClientId defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public DatarouterClusterSettingPlugin build() {
            return new DatarouterClusterSettingPlugin(new DatarouterClusterSettingDaoModule(this.defaultClientId, this.defaultClientId));
        }
    }
}

