/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.service;

import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingConfigScanner;
import io.datarouter.clustersetting.config.DatarouterClusterSettingPaths;
import io.datarouter.clustersetting.service.ClusterSettingService;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClusterSettingDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterClusterSettingConfigScanner configScanner;
    @Inject
    private ClusterSettingService settingService;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private DatarouterClusterSettingPaths paths;

    public Optional<ContainerTag> getPageContent() {
        Optional redundantTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.REDUNDANT).listTo(settings -> this.makePageTable((List<ClusterSetting>)settings, "Redundant"));
        Optional expiredTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.EXPIRED).listTo(settings -> this.makePageTable((List<ClusterSetting>)settings, "Expired"));
        Optional oldTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.OLD).listTo(settings -> this.makePageTable((List<ClusterSetting>)settings, "Old"));
        Optional unknownTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.UNKNOWN).listTo(settings -> this.makePageTable((List<ClusterSetting>)settings, "Unknown"));
        List tables = Scanner.of((Object[])new Optional[]{redundantTable, expiredTable, oldTable, unknownTable}).include(Optional::isPresent).map(Optional::get).list();
        if (tables.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Settings", this.paths.datarouter.settings);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, TagCreator.each((Collection)tables, containerTag -> TagCreator.div((DomContent[])new DomContent[]{containerTag}))}));
    }

    public Optional<ContainerTag> getEmailContent() {
        Optional redundantTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.REDUNDANT).listTo(settings -> this.makeEmailTable((List<ClusterSetting>)settings, "Redundant"));
        Optional expiredTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.EXPIRED).listTo(settings -> this.makeEmailTable((List<ClusterSetting>)settings, "Expired"));
        Optional oldTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.OLD).listTo(settings -> this.makeEmailTable((List<ClusterSetting>)settings, "Old"));
        Optional unknownTable = (Optional)this.settingService.scanWithValidity(ClusterSettingValidity.UNKNOWN).listTo(settings -> this.makeEmailTable((List<ClusterSetting>)settings, "Unknown"));
        List tables = Scanner.of((Object[])new Optional[]{redundantTable, expiredTable, oldTable, unknownTable}).include(Optional::isPresent).map(Optional::get).list();
        if (tables.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Settings", this.paths.datarouter.settings);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, TagCreator.each((Collection)tables, containerTag -> TagCreator.div((DomContent[])new DomContent[]{containerTag}))}));
    }

    public String getTitle() {
        return "Cluster Settings";
    }

    private Optional<ContainerTag> makePageTable(List<ClusterSetting> settings, String header) {
        if (settings.isEmpty()) {
            return Optional.empty();
        }
        ContainerTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Name").withClass("w-50"), row -> TagCreator.td((DomContent[])new DomContent[]{this.configScanner.makeSettingLink(row.getName())})).withHtmlColumn((DomContent)TagCreator.th((String)"Value").withClass("w-50"), row -> TagCreator.td((String)row.getValue())).build(settings);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)header), table}));
    }

    private Optional<ContainerTag> makeEmailTable(List<ClusterSetting> settings, String header) {
        if (settings.isEmpty()) {
            return Optional.empty();
        }
        ContainerTag table = new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Name", row -> this.configScanner.makeSettingLink(row.getName()))).build(settings);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)header), table}));
    }
}

