/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.service;

import io.datarouter.clustersetting.service.CachedClusterSettingNames;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClusterSettingSearchService {
    @Inject
    private CachedClusterSettingNames cachedClusterSettingNames;

    public List<SettingNameMatchResult> searchSettingNames(String query, int limit) {
        return ((TreeSet)this.cachedClusterSettingNames.get()).stream().map(name -> this.getMatchResultFromNameAndQuery((String)name, query)).sorted(Comparator.comparingInt(SettingNameMatchResult::getMatchPercentage).reversed()).limit(limit).collect(Collectors.toList());
    }

    private SettingNameMatchResult getMatchResultFromNameAndQuery(String name, String query) {
        String lowerName = name.toLowerCase();
        String lowerQuery = query.toLowerCase();
        int matchWeight = 0;
        int queryIndex = 0;
        int incrementAmount = 1;
        char[] cArray = lowerQuery.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int indexOfChar = lowerName.indexOf(c, queryIndex);
            if (indexOfChar != -1) {
                incrementAmount = indexOfChar == queryIndex ? ++incrementAmount : 1;
                matchWeight += incrementAmount;
                queryIndex = indexOfChar + 1;
            }
            ++n2;
        }
        int normalizedMatchWeight = matchWeight * 100 / query.length();
        return new SettingNameMatchResult(name, normalizedMatchWeight);
    }

    public static class SettingNameMatchResult {
        private final String name;
        private final int matchWeight;

        public SettingNameMatchResult(String name, int matchPercentage) {
            this.name = name;
            this.matchWeight = matchPercentage;
        }

        public String getName() {
            return this.name;
        }

        public int getMatchPercentage() {
            return this.matchWeight;
        }
    }
}

