/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.service;

import io.datarouter.clustersetting.ClusterSettingComparisonTool;
import io.datarouter.clustersetting.ClusterSettingFinder;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.ClusterSettingScopeComparator;
import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingRoot;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.clustersetting.storage.clustersetting.DatarouterClusterSettingDao;
import io.datarouter.clustersetting.storage.clustersettinglog.DatarouterClusterSettingLogDao;
import io.datarouter.clustersetting.web.dto.ClusterSettingAndValidityJspDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.storage.util.KeyRangeTool;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Range;
import io.datarouter.webappinstance.service.WebappInstanceService;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClusterSettingService {
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterClusterSettingRoot clusterSettingRoot;
    @Inject
    private DatarouterClusterSettingDao clusterSettingDao;
    @Inject
    private DatarouterClusterSettingLogDao clusterSettingLogDao;
    @Inject
    private DatarouterWebappInstanceDao webappInstanceDao;
    @Inject
    private ClusterSettingFinder clusterSettingFinder;
    @Inject
    private SettingRoot.SettingRootFinder settingRootFinder;
    @Inject
    private ServerTypes serverTypes;
    @Inject
    private WebappInstanceService webappInstanceService;

    public <T> T getSettingValueForWebappInstance(CachedSetting<T> memorySetting, WebappInstance webappInstance) {
        List<ClusterSetting> settingsWithName = this.clusterSettingFinder.getAllSettingsWithName(memorySetting.getName());
        Optional<ClusterSetting> mostSpecificSetting = ClusterSettingComparisonTool.getMostSpecificSettingForWebappInstance(settingsWithName, webappInstance);
        if (mostSpecificSetting.isPresent()) {
            return ClusterSettingComparisonTool.getTypedValueOrUseDefaultFrom(mostSpecificSetting, memorySetting);
        }
        DatarouterEnvironmentType environmentType = new DatarouterEnvironmentType(this.datarouterProperties.getEnvironmentType());
        DefaultSettingValue defaultSettingValue = memorySetting.getDefaultSettingValue();
        ServerType webAppInstanceServerType = this.serverTypes.fromPersistentString(webappInstance.getServerType());
        String serverName = this.datarouterProperties.getServerName();
        String environmentName = this.datarouterProperties.getEnvironment();
        return (T)defaultSettingValue.getValue(environmentType, environmentName, webAppInstanceServerType, serverName);
    }

    public <T> Map<WebappInstance, T> getSettingValueByWebappInstance(CachedSetting<T> memorySetting) {
        return this.webappInstanceDao.scan().toMap(Function.identity(), instance -> this.getSettingValueForWebappInstance(memorySetting, (WebappInstance)instance));
    }

    public Scanner<ClusterSetting> scanWithValidity(ClusterSettingValidity validity) {
        WebappInstance currentWebappInstance = this.webappInstanceDao.get(this.webappInstanceService.buildCurrentWebappInstanceKey());
        return this.clusterSettingDao.scan().exclude(setting -> setting.getName().startsWith("datarouter")).include(setting -> this.getValidityForWebappInstance((ClusterSetting)((Object)setting), currentWebappInstance) == validity);
    }

    public Scanner<ClusterSetting> scanAllWebappInstancesWithRedundantValidity() {
        List allWebappInstances = this.webappInstanceDao.scan().list();
        return this.clusterSettingDao.scan().exclude(setting -> setting.getName().startsWith("datarouter")).include(setting -> Scanner.of((Iterable)allWebappInstances).allMatch(webappInstance -> this.getValidityForWebappInstance((ClusterSetting)((Object)setting), (WebappInstance)webappInstance) == ClusterSettingValidity.REDUNDANT));
    }

    public Scanner<ClusterSettingAndValidityJspDto> scanClusterSettingAndValidityWithPrefix(String prefix) {
        WebappInstance currentWebappInstance = this.webappInstanceDao.get(this.webappInstanceService.buildCurrentWebappInstanceKey());
        Range range = prefix == null ? Range.everything() : KeyRangeTool.forPrefixWithWildcard((String)prefix, name -> new ClusterSettingKey(name, null, null, null));
        return this.clusterSettingDao.scan((Range<ClusterSettingKey>)range).map(setting -> {
            ClusterSettingValidity validity = this.getValidityForWebappInstance((ClusterSetting)((Object)setting), currentWebappInstance);
            return new ClusterSettingAndValidityJspDto((ClusterSetting)((Object)setting), validity);
        });
    }

    private ClusterSettingValidity getValidityForWebappInstance(ClusterSetting databeanSetting, WebappInstance webappInstance) {
        String name = databeanSetting.getName();
        ClusterSettingScope scope = databeanSetting.getScope();
        if (!this.settingRootFinder.isRecognized(name)) {
            return ClusterSettingValidity.UNKNOWN;
        }
        CachedSetting memorySetting = this.settingRootFinder.getSettingByName(name).orElse(null);
        if (memorySetting == null) {
            return ClusterSettingValidity.EXPIRED;
        }
        if (scope == ClusterSettingScope.SERVER_TYPE) {
            String serverType = databeanSetting.getServerType();
            try {
                this.serverTypes.fromPersistentString(serverType);
            }
            catch (RuntimeException e) {
                return ClusterSettingValidity.INVALID_SERVER_TYPE;
            }
        }
        if (scope == ClusterSettingScope.SERVER_NAME) {
            String serverName = databeanSetting.getServerName();
            String serverTypeFromWebappInstanceDao = (String)this.webappInstanceDao.getServerTypeByServerName().get(serverName);
            if (StringTool.isEmpty((String)serverTypeFromWebappInstanceDao)) {
                return ClusterSettingValidity.INVALID_SERVER_NAME;
            }
        }
        if (this.isClusterSettingRedundantForWebappInstance(memorySetting, databeanSetting, webappInstance)) {
            return ClusterSettingValidity.REDUNDANT;
        }
        int oldSettingAlertThresholdDays = (Integer)this.clusterSettingRoot.oldSettingAlertThresholdDays.get();
        if (((Set)this.clusterSettingRoot.settingsExcludedFromOldSettingsAlert.get()).stream().noneMatch(setting -> StringTool.containsCaseInsensitive((String)name, (String)setting)) && this.clusterSettingLogDao.isOldDatabaseSetting(databeanSetting, oldSettingAlertThresholdDays)) {
            return ClusterSettingValidity.OLD;
        }
        return ClusterSettingValidity.VALID;
    }

    private boolean isClusterSettingRedundantForWebappInstance(CachedSetting<?> memorySetting, ClusterSetting databeanSetting, WebappInstance webappInstance) {
        List<ClusterSetting> databeanSettings = this.clusterSettingFinder.getAllSettingsWithName(memorySetting.getName());
        List<ClusterSetting> appliesToWebappInstance = ClusterSettingComparisonTool.appliesToWebappInstance(databeanSettings, webappInstance);
        if (!appliesToWebappInstance.contains((Object)databeanSetting)) {
            return false;
        }
        appliesToWebappInstance.sort(new ClusterSettingScopeComparator().reversed());
        boolean allMatch = Scanner.of(appliesToWebappInstance).advanceUntil(setting -> ClusterSettingComparisonTool.equal(databeanSetting, setting)).allMatch(setting -> setting.getValue().equals(databeanSetting.getValue()));
        if (allMatch) {
            DefaultSettingValue defaultSettingValue = memorySetting.getDefaultSettingValue();
            Object defaultValue = defaultSettingValue.getValue(new DatarouterEnvironmentType(this.datarouterProperties.getEnvironmentType()), this.datarouterProperties.getEnvironment(), this.datarouterProperties.getServerType(), this.datarouterProperties.getServerName());
            Object databeanSettingValue = databeanSetting.getTypedValue(memorySetting);
            return Objects.equals(defaultValue, databeanSettingValue);
        }
        return false;
    }

    public String checkValidJobSettingOnAnyServerType(CachedSetting<Boolean> setting) {
        Map<WebappInstance, Boolean> allSettings = this.getSettingValueByWebappInstance(setting);
        Optional<Boolean> validSetting = allSettings.values().stream().filter(BooleanTool::isTrue).findFirst();
        if (validSetting.isPresent()) {
            return "";
        }
        return String.valueOf(setting.getName()) + " is not enabled on at least one server of any type";
    }

    public Integer checkValidJobletSettingOnAnyServerType(CachedSetting<Integer> setting) {
        Map<WebappInstance, Integer> allSettings = this.getSettingValueByWebappInstance(setting);
        return allSettings.values().stream().filter(value -> value != 0).findFirst().orElse(-1);
    }
}

