/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.storage.clustersetting;

import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.enums.StringEnumField;
import io.datarouter.model.field.imp.enums.StringEnumFieldKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.util.enums.StringEnum;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import java.util.List;
import java.util.Objects;

public class ClusterSettingKey
extends BaseRegularPrimaryKey<ClusterSettingKey> {
    private String name;
    private ClusterSettingScope scope;
    private String serverType;
    private String serverName;

    ClusterSettingKey() {
    }

    public ClusterSettingKey(String name, ClusterSettingScope scope, String serverType, String serverName) {
        this.name = name;
        this.scope = scope;
        this.serverType = serverType;
        this.serverName = serverName;
    }

    public List<Field<?>> getFields() {
        return List.of(new StringField(FieldKeys.name, this.name), new StringEnumField(FieldKeys.scope, (StringEnum)this.scope), new StringField(FieldKeys.serverType, this.serverType), new StringField(FieldKeys.serverName, this.serverName));
    }

    public boolean appliesToWebappInstance(WebappInstance app) {
        if (ClusterSettingScope.DEFAULT_SCOPE == this.scope) {
            return true;
        }
        if (ClusterSettingScope.SERVER_TYPE == this.scope) {
            return Objects.equals(this.serverType, app.getServerType());
        }
        if (ClusterSettingScope.SERVER_NAME == this.scope) {
            return Objects.equals(this.serverName, ((WebappInstanceKey)app.getKey()).getServerName());
        }
        throw new RuntimeException("unknown key.scope");
    }

    public ClusterSettingScope getScope() {
        return this.scope;
    }

    public void setScope(ClusterSettingScope scope) {
        this.scope = scope;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class FieldKeys {
        public static final StringFieldKey name = new StringFieldKey("name");
        public static final StringEnumFieldKey<ClusterSettingScope> scope = new StringEnumFieldKey("scope", ClusterSettingScope.class).withSize(20);
        public static final StringFieldKey serverType = new StringFieldKey("serverType").withSize(50);
        public static final StringFieldKey serverName = new StringFieldKey("serverName").withSize(50);
    }
}

