/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.storage.clustersettinglog;

import io.datarouter.clustersetting.ClusterSettingLogAction;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.custom.LongDateFieldKey;
import io.datarouter.model.field.imp.enums.StringEnumField;
import io.datarouter.model.field.imp.enums.StringEnumFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.enums.StringEnum;
import java.time.Instant;
import java.util.List;

public class ClusterSettingLog
extends BaseDatabean<ClusterSettingLogKey, ClusterSettingLog> {
    private ClusterSettingScope scope;
    private String serverType;
    private String serverName;
    private String value;
    private ClusterSettingLogAction action;
    private String changedBy;
    private String comment;

    public ClusterSettingLog() {
        super((PrimaryKey)new ClusterSettingLogKey(null, null));
    }

    public ClusterSettingLog(ClusterSetting clusterSetting, ClusterSettingLogAction action, String changedBy, String comment) {
        super((PrimaryKey)new ClusterSettingLogKey(clusterSetting.getName(), Instant.now()));
        this.scope = clusterSetting.getScope();
        this.serverType = clusterSetting.getServerType();
        this.serverName = clusterSetting.getServerName();
        this.value = clusterSetting.getValue();
        this.action = action;
        this.changedBy = changedBy;
        this.comment = comment;
    }

    public Class<ClusterSettingLogKey> getKeyClass() {
        return ClusterSettingLogKey.class;
    }

    public String toString() {
        return String.valueOf(((ClusterSettingLogKey)this.getKey()).toString()) + ":" + this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ClusterSettingScope getScope() {
        return this.scope;
    }

    public void setScope(ClusterSettingScope scope) {
        this.scope = scope;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public ClusterSettingLogAction getAction() {
        return this.action;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String getComment() {
        return this.comment;
    }

    public static class ClusterSettingLogFielder
    extends BaseDatabeanFielder<ClusterSettingLogKey, ClusterSettingLog> {
        public ClusterSettingLogFielder() {
            super(ClusterSettingLogKey.class);
        }

        public List<Field<?>> getNonKeyFields(ClusterSettingLog databean) {
            return List.of(new StringEnumField(ClusterSettingKey.FieldKeys.scope, (StringEnum)databean.scope), new StringField(ClusterSettingKey.FieldKeys.serverType, databean.serverType), new StringField(ClusterSettingKey.FieldKeys.serverName, databean.serverName), new StringField(ClusterSetting.FieldKeys.value, databean.value), new StringEnumField(FieldKeys.action, (StringEnum)databean.action), new StringField(FieldKeys.changedBy, databean.changedBy), new StringField(FieldKeys.comment, databean.comment));
        }
    }

    public static class FieldKeys {
        public static final LongDateFieldKey timestamp = new LongDateFieldKey("timestamp");
        public static final StringFieldKey changedBy = new StringFieldKey("changedBy").withSize(50);
        public static final StringEnumFieldKey<ClusterSettingLogAction> action = new StringEnumFieldKey("action", ClusterSettingLogAction.class).withSize(20);
        public static final StringFieldKey comment = new StringFieldKey("comment");
    }
}

