/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.web;

import io.datarouter.clustersetting.ClusterSettingLogAction;
import io.datarouter.clustersetting.ClusterSettingScope;
import io.datarouter.clustersetting.ClusterSettingValidity;
import io.datarouter.clustersetting.config.DatarouterClusterSettingFiles;
import io.datarouter.clustersetting.service.ClusterSettingSearchService;
import io.datarouter.clustersetting.service.ClusterSettingService;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSetting;
import io.datarouter.clustersetting.storage.clustersetting.ClusterSettingKey;
import io.datarouter.clustersetting.storage.clustersetting.DatarouterClusterSettingDao;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLog;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogByReversedCreatedMsKey;
import io.datarouter.clustersetting.storage.clustersettinglog.ClusterSettingLogKey;
import io.datarouter.clustersetting.storage.clustersettinglog.DatarouterClusterSettingLogDao;
import io.datarouter.clustersetting.web.dto.ClusterSettingJspDto;
import io.datarouter.clustersetting.web.dto.ClusterSettingLogJspDto;
import io.datarouter.clustersetting.web.dto.SettingJspDto;
import io.datarouter.clustersetting.web.dto.SettingNodeJspDto;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingCategory;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.enums.Displayable;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Pair;
import io.datarouter.util.tuple.Range;
import io.datarouter.web.config.DatarouterWebPaths;
import io.datarouter.web.email.DatarouterEmailLinkBuilder;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.optional.OptionalBoolean;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ClusterSettingsHandler
extends BaseHandler {
    private static final int CLUSTER_SETTING_LOGS_PAGE_SIZE = 50;
    private static final int CLUSTER_SETTING_SEARCH_RESULTS = 10;
    @Inject
    private DatarouterHtmlEmailService datarouterHtmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private SettingRoot.SettingRootFinder settingRootFinder;
    @Inject
    private ServerTypes serverTypes;
    @Inject
    private DatarouterClusterSettingDao clusterSettingDao;
    @Inject
    private DatarouterClusterSettingLogDao clusterSettingLogDao;
    @Inject
    private DatarouterClusterSettingFiles files;
    @Inject
    private ClusterSettingService clusterSettingService;
    @Inject
    private DatarouterAdministratorEmailService datarouterAdministratorEmailService;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterWebPaths datarouterWebPaths;
    @Inject
    private ClusterSettingSearchService clusterSettingSearchService;
    @Inject
    private ChangelogRecorder changelogRecorder;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav customSettings(OptionalString prefix) {
        Mav mav = new Mav(this.files.jsp.admin.datarouter.setting.editSettingsJsp);
        mav.put("serverTypeOptions", (Object)this.serverTypes.getHtmlSelectOptionsVarNames());
        mav.put("validities", (Object)ClusterSettingsHandler.buildLegend());
        this.clusterSettingService.scanClusterSettingAndValidityWithPrefix((String)prefix.orElse(null)).flush(settings -> {
            Object object = mav.put("rows", settings);
        });
        return mav;
    }

    @BaseHandler.Handler
    public List<String> roots() {
        return Scanner.of((Iterable)this.settingRootFinder.getRootNodesSortedByShortName()).map(SettingNode::getShortName).list();
    }

    @BaseHandler.Handler
    public Boolean isRecognizedRoot(String name) {
        return this.settingRootFinder.isRecognizedRootName(name);
    }

    @BaseHandler.Handler
    public ClusterSettingActionResultJson create() {
        return this.putSettingFromParams();
    }

    @BaseHandler.Handler
    public ClusterSettingActionResultJson update() {
        return this.putSettingFromParams();
    }

    @BaseHandler.Handler
    public ClusterSettingActionResultJson delete() {
        ClusterSettingLogAction action = ClusterSettingLogAction.DELETED;
        ClusterSettingActionResultJson result = new ClusterSettingActionResultJson(action);
        ClusterSettingKey clusterSettingKey = this.parseClusterSettingKeyFromParams();
        String comment = this.parseCommentFromParams();
        String changedBy = this.getRequestorsUsername();
        ClusterSetting clusterSetting = this.clusterSettingDao.get(clusterSettingKey);
        ClusterSettingLog clusterSettingLog = new ClusterSettingLog(clusterSetting, action, changedBy, comment);
        this.clusterSettingDao.delete(clusterSettingKey);
        this.clusterSettingLogDao.put(clusterSettingLog);
        String oldValue = clusterSetting.getValue();
        this.sendEmail(clusterSettingLog, oldValue);
        this.recordChangelog(((ClusterSettingLogKey)clusterSettingLog.getKey()).getName(), clusterSettingLog.getAction().getPersistentString(), clusterSettingLog.getChangedBy(), comment);
        return result.markSuccess();
    }

    @BaseHandler.Handler
    public Mav logsForName(String name) {
        Scanner logScanner;
        Mav mav = new Mav(this.files.jsp.admin.datarouter.setting.clusterSettingsLogJsp);
        mav.put("showingAllSettings", (Object)false);
        String settingName = name.endsWith(".") ? StringTool.getStringBeforeLastOccurrence((char)'.', (String)name) : name;
        mav.put("nameParts", (Object)settingName.split("\\."));
        Optional<SettingNode> node = this.getSettingNode(settingName);
        mav.put("showingNodeSettings", (Object)node.isPresent());
        if (node.isPresent()) {
            List<ClusterSettingLogKey> prefixes = node.get().getListSettings().stream().map(Setting::getName).map(ClusterSettingLogKey::createPrefix).collect(Collectors.toList());
            logScanner = this.clusterSettingLogDao.scanWithPrefixes(prefixes).sorted(Comparator.comparing(log -> ((ClusterSettingLogKey)log.getKey()).getCreated()).reversed());
        } else {
            ClusterSettingLogKey prefix = ClusterSettingLogKey.createPrefix(settingName);
            logScanner = this.clusterSettingLogDao.scanWithPrefix(prefix);
        }
        logScanner.map(ClusterSettingLogJspDto::new).flush(logs -> {
            Object object = mav.put("logs", logs);
        });
        return mav;
    }

    @BaseHandler.Handler
    public Mav logsForAll(OptionalString explicitStartIso, OptionalBoolean inclusiveStart) {
        Mav mav = new Mav(this.files.jsp.admin.datarouter.setting.clusterSettingsLogJsp);
        mav.put("showingAllSettings", (Object)true);
        long startCreatedMs = explicitStartIso.map(isoDate -> LocalDateTime.parse(isoDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME)).map(localDate -> localDate.atZone(ZoneId.systemDefault())).map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli).orElseGet(System::currentTimeMillis);
        long reverseStartCreatedMs = Long.MAX_VALUE - startCreatedMs;
        Range range = new Range((Comparable)((Object)new ClusterSettingLogByReversedCreatedMsKey(reverseStartCreatedMs, null)), ((Boolean)inclusiveStart.orElse((Object)false)).booleanValue());
        this.clusterSettingLogDao.scanByReversedCreatedMs((Range<ClusterSettingLogByReversedCreatedMsKey>)range, 50).map(ClusterSettingLogJspDto::new).flush(logs -> {
            Object object = mav.put("logs", logs);
        }).flush(logs -> {
            Object object = mav.put("hasNextPage", (Object)(logs.size() == 50 ? 1 : 0));
        });
        mav.put("hasPreviousPage", (Object)explicitStartIso.isPresent());
        return mav;
    }

    @BaseHandler.Handler
    public Mav browseSettings(OptionalString name) {
        Mav mav = new Mav(this.files.jsp.admin.datarouter.setting.browseSettingsJsp);
        String requestedNodeName = (String)name.orElse((Object)this.settingRootFinder.getName());
        mav.put("nodeName", (Object)requestedNodeName);
        LinkedHashMap<SettingCategory.SimpleSettingCategory, TreeSet> categoryMap = new LinkedHashMap<SettingCategory.SimpleSettingCategory, TreeSet>();
        for (Map.Entry entry : this.settingRootFinder.getRootNodesByCategory().entrySet()) {
            TreeSet nodes = ((Set)entry.getValue()).stream().map(SettingNodeJspDto::new).collect(Collectors.toCollection(() -> new TreeSet<SettingNodeJspDto>(Comparator.comparing(SettingNodeJspDto::getShortName))));
            categoryMap.put((SettingCategory.SimpleSettingCategory)entry.getKey(), nodes);
            mav.put("currentCategory", (Object)((SettingCategory.SimpleSettingCategory)entry.getKey()).getDisplay());
        }
        mav.put("categoryMap", categoryMap);
        mav.put("serverTypeOptions", (Object)this.serverTypes.getHtmlSelectOptionsVarNames());
        Optional<SettingNode> node = this.getSettingNode(requestedNodeName);
        boolean trySearchingForSpecificSetting = node.isEmpty();
        if (trySearchingForSpecificSetting) {
            node = this.getMostRecentAncestorSettingNode(requestedNodeName);
        }
        if (node.isEmpty()) {
            return mav;
        }
        node.ifPresent(settingNode -> {
            String rootName = StringTool.getStringBeforeFirstOccurrence((char)'.', (String)settingNode.getName());
            this.settingRootFinder.getRootNodesSortedByShortName().stream().filter(rootNode -> rootNode.getShortName().equals(rootName)).findFirst().map(SettingRoot.class::cast).map(SettingRoot::getSettingCategory).map(Displayable::getDisplay).ifPresent(category -> {
                Object object = mav.put("currentCategory", category);
            });
            mav.put("currentRootName", (Object)rootName);
        });
        mav.put("ancestors", (Object)Scanner.of((Iterable)this.settingRootFinder.getDescendants(node.get().getName())).map(SettingNodeJspDto::new).list());
        mav.put("currentRootName", (Object)node.get().getName().substring(0, node.get().getName().indexOf(46)));
        mav.put("children", (Object)Scanner.of((Iterable)node.get().getListChildren()).map(SettingNodeJspDto::new).list());
        List<Object> settingsList = node.get().getListSettings();
        if (trySearchingForSpecificSetting) {
            settingsList = settingsList.stream().filter(setting -> setting.getName().equals(requestedNodeName)).collect(Collectors.toList());
        }
        HashMap customSettingsByName = new HashMap();
        for (CachedSetting setting2 : settingsList) {
            ClusterSettingKey settingKey = new ClusterSettingKey(setting2.getName(), null, null, null);
            this.clusterSettingDao.scanWithPrefix(settingKey).map(ClusterSettingJspDto::new).flush(customSettings -> {
                List list = customSettingsByName.put(setting2.getName(), customSettings);
            });
        }
        mav.put("listSettings", (Object)Scanner.of((Iterable)settingsList).map(SettingJspDto::new).list());
        mav.put("mapListsCustomSettings", customSettingsByName);
        return mav;
    }

    @BaseHandler.Handler
    public List<ClusterSettingSearchService.SettingNameMatchResult> searchSettingNames(String term) {
        return this.clusterSettingSearchService.searchSettingNames(term, 10);
    }

    private ClusterSettingActionResultJson putSettingFromParams() {
        ClusterSettingKey clusterSettingKey = this.parseClusterSettingKeyFromParams();
        String comment = this.parseCommentFromParams();
        String value = this.params.optional("value").orElse(null);
        ClusterSetting clusterSetting = new ClusterSetting(clusterSettingKey, value);
        Optional setting = this.settingRootFinder.getSettingByName(clusterSetting.getName());
        ClusterSettingLogAction action = this.clusterSettingDao.exists(clusterSettingKey) ? ClusterSettingLogAction.UPDATED : ClusterSettingLogAction.INSERTED;
        ClusterSettingActionResultJson result = new ClusterSettingActionResultJson(action);
        if (setting.isPresent() && !((CachedSetting)setting.get()).isValid(clusterSetting.getValue())) {
            String badNewValue = clusterSetting.getValue();
            String error = "Invalid value detected, setting did not accept new value: \"" + badNewValue + "\"";
            return result.markError(error);
        }
        String oldValue = setting.map(CachedSetting::toStringValue).orElse("?");
        String changedBy = this.getRequestorsUsername();
        ClusterSettingLog clusterSettingLog = new ClusterSettingLog(clusterSetting, action, changedBy, comment);
        this.clusterSettingDao.put(clusterSetting);
        this.clusterSettingLogDao.put(clusterSettingLog);
        this.sendEmail(clusterSettingLog, oldValue);
        this.recordChangelog(((ClusterSettingLogKey)clusterSettingLog.getKey()).getName(), clusterSettingLog.getAction().getPersistentString(), clusterSettingLog.getChangedBy(), clusterSettingLog.getComment());
        return result.markSuccess();
    }

    private String normalizeSettingNodeName(String name) {
        return name.endsWith(".") ? name : String.valueOf(name) + '.';
    }

    private Optional<SettingNode> getSettingNode(String name) {
        return this.settingRootFinder.getNode(this.normalizeSettingNodeName(name));
    }

    private Optional<SettingNode> getMostRecentAncestorSettingNode(String name) {
        return this.settingRootFinder.getMostRecentAncestorNode(this.normalizeSettingNodeName(name));
    }

    private String getRequestorsUsername() {
        return this.getSessionInfo().getNonEmptyUsernameOrElse("");
    }

    private String parseCommentFromParams() {
        return this.params.optional("comment").filter(StringTool::notNullNorEmptyNorWhitespace).orElse(null);
    }

    private ClusterSettingKey parseClusterSettingKeyFromParams() {
        String name = this.params.required("name").trim();
        String serverTypePersistentString = this.params.required("serverType");
        String serverName = this.params.optional("serverName").orElse("");
        ClusterSettingScope scope = ClusterSettingScope.fromParams(serverTypePersistentString, serverName);
        return new ClusterSettingKey(name, scope, serverTypePersistentString, serverName);
    }

    private void sendEmail(ClusterSettingLog log, String oldValue) {
        String from = this.datarouterProperties.getAdministratorEmail();
        String to = String.valueOf(this.datarouterAdministratorEmailService.getAdministratorEmailAddressesCsv()) + "," + this.getSessionInfo().getNonEmptyUsernameOrElse("");
        String title = "Setting Update";
        String primaryHref = this.completeLink(this.datarouterHtmlEmailService.startLinkBuilder(), log).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.datarouterHtmlEmailService.startEmailBuilder().withTitle(title).withTitleHref(primaryHref).withContent(new ClusterSettingChangeEmailContent(log, oldValue).build());
        this.datarouterHtmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private static String buildLegend() {
        J2HtmlLegendTable legend = new J2HtmlLegendTable().withClass("table table-sm my-4 border");
        ClusterSettingValidity.stream().forEach(validity -> {
            J2HtmlLegendTable j2HtmlLegendTable2 = legend.withEntry(validity.persistentString, validity.description, validity.color);
        });
        return legend.build().renderFormatted();
    }

    private DatarouterEmailLinkBuilder completeLink(DatarouterEmailLinkBuilder linkBuilder, ClusterSettingLog log) {
        return linkBuilder.withLocalPath(this.datarouterWebPaths.datarouter.settings).withParam("submitAction", "browseSettings").withParam("name", ((ClusterSettingLogKey)log.getKey()).getName());
    }

    private void recordChangelog(String name, String action, String username, String comment) {
        this.changelogRecorder.record("ClusterSetting", name, action, username, comment);
    }

    protected static class ClusterSettingActionResultJson {
        public final ClusterSettingLogAction clusterSettingLogAction;
        public boolean success = false;
        public String error;

        public ClusterSettingActionResultJson(ClusterSettingLogAction clusterSettingLogAction) {
            this.clusterSettingLogAction = clusterSettingLogAction;
        }

        public ClusterSettingActionResultJson markSuccess() {
            this.success = true;
            return this;
        }

        public ClusterSettingActionResultJson markError(String error) {
            this.success = false;
            this.error = error;
            return this;
        }
    }

    private class ClusterSettingChangeEmailContent {
        private final ClusterSettingLog log;
        private final String oldValue;

        public ClusterSettingChangeEmailContent(ClusterSettingLog log, String oldValue) {
            this.log = log;
            this.oldValue = oldValue;
        }

        private ContainerTag build() {
            ArrayList<Pair> kvs = new ArrayList<Pair>();
            kvs.add(new Pair((Object)"environment", (Object)this.makeText(ClusterSettingsHandler.this.datarouterProperties.getEnvironment())));
            kvs.add(new Pair((Object)"service", (Object)this.makeText(ClusterSettingsHandler.this.datarouterService.getName())));
            kvs.add(new Pair((Object)"host", (Object)this.makeText(ClusterSettingsHandler.this.datarouterProperties.getServerName())));
            kvs.add(new Pair((Object)"user", (Object)this.makeText(this.log.getChangedBy())));
            kvs.add(new Pair((Object)"action", (Object)this.makeText(this.log.getAction().getPersistentString())));
            kvs.add(new Pair((Object)"setting", (Object)this.makeClusterSettingLogLink()));
            if (ObjectTool.notEquals((Object)ServerType.UNKNOWN.getPersistentString(), (Object)this.log.getServerType())) {
                kvs.add(new Pair((Object)"serverType", (Object)this.makeText(this.log.getServerType())));
            }
            if (StringTool.notEmpty((String)this.log.getServerName())) {
                kvs.add(new Pair((Object)"serverName", (Object)this.makeText(this.log.getServerName())));
            }
            if (ClusterSettingLogAction.INSERTED != this.log.getAction()) {
                kvs.add(new Pair((Object)"old value", (Object)this.makeText(this.oldValue)));
            }
            if (ClusterSettingLogAction.DELETED != this.log.getAction()) {
                kvs.add(new Pair((Object)"new value", (Object)this.makeText(this.log.getValue())));
            }
            String comment = StringTool.notNullNorEmptyNorWhitespace((String)this.log.getComment()) ? this.log.getComment() : "No comment provided";
            kvs.add(new Pair((Object)"comment", (Object)this.makeText(comment)));
            return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> this.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, Pair::getRight)).build(kvs);
        }

        private DomContent makeDivBoldRight(String text) {
            return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
        }

        private DomContent makeText(String text) {
            return TagCreator.text((String)text);
        }

        private DomContent makeClusterSettingLogLink() {
            return TagCreator.a((String)((ClusterSettingLogKey)this.log.getKey()).getName()).withHref(ClusterSettingsHandler.this.completeLink(ClusterSettingsHandler.this.datarouterHtmlEmailService.startLinkBuilder(), this.log).build());
        }
    }
}

