/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting.web.dto;

import io.datarouter.clustersetting.web.dto.ClusterSettingDefaultJspDto;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.cached.CachedSetting;
import java.util.ArrayList;
import java.util.List;

public class SettingJspDto {
    private final String name;
    private final Boolean hasRedundantCustomValue;
    private final Boolean hasCustomValue;
    private final String value;
    private final String defaultValue;
    private final List<ClusterSettingDefaultJspDto> codeOverrides;

    public <T> SettingJspDto(CachedSetting<T> setting) {
        this.name = setting.getName();
        this.hasRedundantCustomValue = setting.getHasRedundantCustomValue();
        this.hasCustomValue = setting.getHasCustomValue();
        this.value = setting.toStringValue();
        this.defaultValue = setting.toStringDefaultValue();
        this.codeOverrides = this.toDefaults(setting, setting.getDefaultSettingValue());
    }

    private <T> List<ClusterSettingDefaultJspDto> toDefaults(CachedSetting<T> setting, DefaultSettingValue<T> defaults) {
        ArrayList<ClusterSettingDefaultJspDto> dtos = new ArrayList<ClusterSettingDefaultJspDto>();
        defaults.getValueByEnvironmentType().forEach((environmentType, value) -> {
            boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, environmentType.getPersistentString(), null, null, null, setting.toStringValue(value)));
        });
        defaults.getValueByServerTypeByEnvironmentType().forEach((environmentType, defaultByServerType) -> defaultByServerType.forEach((serverType, value) -> {
            boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, environmentType.getPersistentString(), null, (String)serverType, null, setting.toStringValue(value)));
        }));
        defaults.getValueByServerNameByEnvironmentType().forEach((environmentType, defaultByServerName) -> defaultByServerName.forEach((serverName, value) -> {
            boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, environmentType.getPersistentString(), null, null, (String)serverName, setting.toStringValue(value)));
        }));
        defaults.getValueByEnvironmentNameByEnvironmentType().forEach((environmentType, defaultByEnvironment) -> defaultByEnvironment.forEach((environmentName, value) -> {
            boolean bl = dtos.add(new ClusterSettingDefaultJspDto(false, environmentType.getPersistentString(), (String)environmentName, null, null, setting.toStringValue(value)));
        }));
        return dtos;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getHasRedundantCustomValue() {
        return this.hasRedundantCustomValue;
    }

    public Boolean getHasCustomValue() {
        return this.hasCustomValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<ClusterSettingDefaultJspDto> getCodeOverrides() {
        return this.codeOverrides;
    }
}

