/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor;

import io.datarouter.conveyor.Conveyor;
import io.datarouter.conveyor.ConveyorCounters;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConveyor
implements Conveyor {
    private static final Logger logger = LoggerFactory.getLogger(BaseConveyor.class);
    protected final String name;
    private final Supplier<Boolean> shouldRunSetting;
    private final Supplier<Boolean> compactExceptionLogging;

    public BaseConveyor(String name, Supplier<Boolean> shouldRun, Supplier<Boolean> compactExceptionLogging) {
        this.name = name;
        this.shouldRunSetting = shouldRun;
        this.compactExceptionLogging = compactExceptionLogging;
    }

    public abstract ProcessBatchResult processBatch();

    public void interrupted() throws Exception {
    }

    @Override
    public void run() {
        try {
            int iteration = 0;
            long start = System.currentTimeMillis();
            while (this.shouldRun()) {
                ++iteration;
                ProcessBatchResult result = this.processBatch();
                if (!result.shouldContinueImmediately) break;
            }
            long duration = System.currentTimeMillis() - start;
            ConveyorCounters.incFinishDrain(this);
            logger.info("drain finished for conveyor={} duration={} iterations={} ", new Object[]{this.name, duration, iteration});
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                try {
                    this.interrupted();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            ConveyorCounters.incException(this);
            if (this.getCompactExceptionLogging()) {
                logger.warn("logging exception so ScheduledExecutorService restarts this Runnable {}", (Object)e.toString());
            }
            logger.warn("swallowing exception so ScheduledExecutorService restarts this Runnable", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean shouldRun() {
        return !Thread.currentThread().isInterrupted() && this.shouldRunSetting.get() != false;
    }

    private boolean getCompactExceptionLogging() {
        try {
            return this.compactExceptionLogging.get();
        }
        catch (Exception e) {
            logger.warn("invalid value for compactExceptionLogging", (Throwable)e);
            return false;
        }
    }

    protected static class ProcessBatchResult {
        public final boolean shouldContinueImmediately;

        public ProcessBatchResult(boolean shouldContinueImmediately) {
            this.shouldContinueImmediately = shouldContinueImmediately;
        }
    }
}

