/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor;

import io.datarouter.conveyor.Conveyor;
import io.datarouter.inject.InstanceRegistry;
import io.datarouter.util.Require;
import io.datarouter.util.concurrent.ExecutorServiceTool;
import io.datarouter.util.concurrent.NamedThreadFactory;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.listener.DatarouterAppListener;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConveyors
implements DatarouterAppListener {
    private static final Logger logger = LoggerFactory.getLogger(BaseConveyors.class);
    private static final long DELAY_SEC = 3L;
    private final Map<String, Pair<ExecutorService, Conveyor>> execsAndConveyorsByName = new TreeMap<String, Pair<ExecutorService, Conveyor>>();
    @Inject
    private InstanceRegistry instanceRegistry;

    protected BaseConveyors() {
    }

    protected void start(Conveyor conveyor, int numThreads) {
        String name = conveyor.getName();
        Require.notContains(this.execsAndConveyorsByName.keySet(), (Object)name, (String)(String.valueOf(name) + " already exists"));
        String threadGroupName = name;
        NamedThreadFactory threadFactory = new NamedThreadFactory(threadGroupName, true);
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(numThreads, (ThreadFactory)threadFactory);
        int i = 0;
        while (i < numThreads) {
            exec.scheduleWithFixedDelay(conveyor, 3L, 3L, TimeUnit.SECONDS);
            ++i;
        }
        this.instanceRegistry.register((Object)exec);
        this.execsAndConveyorsByName.put(name, (Pair<ExecutorService, Conveyor>)new Pair((Object)exec, (Object)conveyor));
    }

    public void onShutDown() {
        for (Map.Entry<String, Pair<ExecutorService, Conveyor>> entry : this.execsAndConveyorsByName.entrySet()) {
            logger.info("shutting down {}", (Object)entry.getKey());
            ExecutorServiceTool.shutdown((ExecutorService)((ExecutorService)entry.getValue().getLeft()), (Duration)Duration.ofSeconds(5L));
        }
    }
}

