/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor;

import io.datarouter.conveyor.Buffer;
import io.datarouter.conveyor.Conveyor;
import io.datarouter.instrumentation.count.Counters;

public class ConveyorCounters {
    private static final String PREFIX = "Conveyor";

    public static void inc(Conveyor conveyor, String action, long by) {
        Counters.inc((String)("Conveyor " + action), (long)by);
        Counters.inc((String)("Conveyor " + conveyor.getName() + " " + action), (long)by);
    }

    public static void inc(Buffer buffer, String action, long by) {
        Counters.inc((String)("Conveyor buffer " + action), (long)by);
        Counters.inc((String)("Conveyor buffer " + buffer.getName() + " " + action), (long)by);
    }

    public static void incPutMultiOpAndDatabeans(Conveyor conveyor, long numDatabeans) {
        ConveyorCounters.inc(conveyor, "putMulti ops", 1L);
        ConveyorCounters.inc(conveyor, "putMulti databeans", numDatabeans);
    }

    public static void incConsumedOpAndDatabeans(Conveyor conveyor, long numDatabeans) {
        ConveyorCounters.inc(conveyor, "consumed ops", 1L);
        ConveyorCounters.inc(conveyor, "consumed databeans", numDatabeans);
    }

    public static void incConsumedOpAndDatabeansWithPriority(Conveyor conveyor, long numDatabeans, String priority) {
        ConveyorCounters.incConsumedOpAndDatabeans(conveyor, numDatabeans);
        ConveyorCounters.inc(conveyor, String.valueOf(priority) + " consumed ops", 1L);
        ConveyorCounters.inc(conveyor, String.valueOf(priority) + " consumed databeans", numDatabeans);
    }

    public static void incAck(Conveyor conveyor) {
        ConveyorCounters.inc(conveyor, "ack", 1L);
    }

    public static void incAck(Conveyor conveyor, long numDatabeans) {
        ConveyorCounters.inc(conveyor, "ack", numDatabeans);
    }

    public static void incAckWithPriority(Conveyor conveyor, String priority) {
        ConveyorCounters.incAck(conveyor);
        ConveyorCounters.inc(conveyor, String.valueOf(priority) + " ack", 1L);
    }

    public static void incException(Conveyor conveyor) {
        ConveyorCounters.inc(conveyor, "exception", 1L);
    }

    public static void incFinishDrain(Conveyor conveyor) {
        ConveyorCounters.inc(conveyor, "finishDrain", 1L);
    }

    public static void incFlushBuffer(Conveyor conveyor, long numDatabeans) {
        ConveyorCounters.inc(conveyor, "flushBuffer", numDatabeans);
    }
}

