/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor;

import io.datarouter.conveyor.Buffer;
import io.datarouter.conveyor.ConveyorCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class MemoryBuffer<T>
implements Buffer {
    private final String name;
    private final Queue<T> queue;

    public MemoryBuffer(String name, int maxSize) {
        this.name = name;
        this.queue = new ArrayBlockingQueue<T>(maxSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean offer(T obj) {
        boolean accepted = this.queue.offer(obj);
        if (!accepted) {
            ConveyorCounters.inc(this, "offer rejected", 1L);
        }
        return accepted;
    }

    public boolean offerMulti(Collection<T> objects) {
        for (T obj : objects) {
            if (this.offer(obj)) continue;
            return false;
        }
        return true;
    }

    public List<T> pollMultiWithLimit(int limit) {
        ArrayList<T> result = new ArrayList<T>();
        while (result.size() < limit) {
            T obj = this.queue.poll();
            if (obj == null) break;
            result.add(obj);
        }
        return result;
    }
}

