/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor.queue;

import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.queue.QueueConsumer;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.queue.QueueMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBatchedLossyQueueConsumerConveyor<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(BaseBatchedLossyQueueConsumerConveyor.class);
    private static final Duration PEEK_TIMEOUT = Duration.ofSeconds(5L);
    private static final int BATCH_SIZE = 100;
    private final QueueConsumer<PK, D> queueConsumer;
    private final Object lock = new Object();
    private List<D> buffer;

    public BaseBatchedLossyQueueConsumerConveyor(String name, Supplier<Boolean> shouldRun, QueueConsumer<PK, D> queueConsumer) {
        super(name, shouldRun, () -> false);
        this.queueConsumer = queueConsumer;
        this.buffer = new ArrayList<D>(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseConveyor.ProcessBatchResult processBatch() {
        List<Object> currentBuffer = Collections.emptyList();
        QueueMessage<PK, D> message = this.queueConsumer.peek(PEEK_TIMEOUT);
        if (message == null) {
            logger.info("peeked conveyor={} nullMessage", (Object)this.name);
            Object object = this.lock;
            synchronized (object) {
                currentBuffer = this.copyAndClearBuffer();
            }
            this.flushBuffer(currentBuffer);
            return new BaseConveyor.ProcessBatchResult(false);
        }
        Object object = this.lock;
        synchronized (object) {
            Databean databean = message.getDatabean();
            logger.info("peeked conveyor={} messageCount={}", (Object)this.name, (Object)1);
            this.buffer.add(databean);
            if (this.buffer.size() >= 100) {
                currentBuffer = this.copyAndClearBuffer();
            }
        }
        logger.info("consumed conveyor={} messageCount={}", (Object)this.name, (Object)1);
        ConveyorCounters.incConsumedOpAndDatabeans(this, 1L);
        this.queueConsumer.ack(message.getKey());
        logger.info("acked conveyor={} messageCount={}", (Object)this.name, (Object)1);
        ConveyorCounters.incAck(this);
        this.flushBuffer(currentBuffer);
        return new BaseConveyor.ProcessBatchResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupted() {
        List<D> currentBuffer;
        Object object = this.lock;
        synchronized (object) {
            currentBuffer = this.copyAndClearBuffer();
        }
        this.flushBuffer(currentBuffer);
    }

    private void flushBuffer(List<D> currentBuffer) {
        if (currentBuffer.isEmpty()) {
            return;
        }
        this.processBuffer(currentBuffer);
        ConveyorCounters.incFlushBuffer(this, currentBuffer.size());
    }

    private List<D> copyAndClearBuffer() {
        List currentBuffer = this.buffer.stream().collect(Collectors.toList());
        this.buffer.clear();
        return currentBuffer;
    }

    protected abstract void processBuffer(List<D> var1);
}

