/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor.queue;

import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.queue.GroupQueueMessage;
import io.datarouter.util.timer.PhaseTimer;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGroupQueueConsumerConveyor<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(BaseGroupQueueConsumerConveyor.class);
    private final GroupQueueConsumer<PK, D> consumer;
    private final Duration peekTimeout;

    public BaseGroupQueueConsumerConveyor(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<PK, D> consumer, Supplier<Boolean> compactExceptionLogging, Duration peekTimeout) {
        super(name, shouldRun, compactExceptionLogging);
        this.consumer = consumer;
        this.peekTimeout = peekTimeout;
    }

    @Override
    public BaseConveyor.ProcessBatchResult processBatch() {
        PhaseTimer timer = new PhaseTimer();
        GroupQueueMessage<PK, D> message = this.consumer.peek(this.peekTimeout);
        if (message == null) {
            logger.info("peeked conveyor={} nullMessage", (Object)this.name);
            return new BaseConveyor.ProcessBatchResult(false);
        }
        List databeans = message.getDatabeans();
        logger.info("peeked conveyor={} messageCount={}", (Object)this.name, (Object)databeans.size());
        timer.add("peek");
        this.processDatabeans(databeans);
        logger.info("wrote conveyor={} messageCount={}", (Object)this.name, (Object)databeans.size());
        timer.add("wrote");
        ConveyorCounters.incPutMultiOpAndDatabeans(this, databeans.size());
        this.consumer.ack(message.getKey());
        logger.info("acked conveyor={} messageCount={}", (Object)this.name, (Object)databeans.size());
        timer.add("acked");
        ConveyorCounters.incAck(this);
        timer.setName("messageCount=" + databeans.size());
        logger.debug("{}", (Object)timer);
        return new BaseConveyor.ProcessBatchResult(true);
    }

    protected abstract void processDatabeans(List<D> var1);
}

