/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor.queue;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class BatchedQueueConsumer<PK extends PrimaryKey<PK>, D extends Databean<PK, D>> {
    private final Function<Config, QueueMessage<PK, D>> peekFunction;
    private final Consumer<Collection<QueueMessageKey>> ackMultiConsumer;

    public BatchedQueueConsumer(Function<Config, QueueMessage<PK, D>> peekFunction, Consumer<Collection<QueueMessageKey>> ackMultiConsumer) {
        this.peekFunction = peekFunction;
        this.ackMultiConsumer = ackMultiConsumer;
    }

    public QueueMessage<PK, D> peek(Duration timeout) {
        return this.peekFunction.apply(new Config().setTimeout(timeout));
    }

    public void ackMulti(Collection<QueueMessageKey> keys) {
        this.ackMultiConsumer.accept(keys);
    }
}

