/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.conveyor.queue;

import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.DatabeanBuffer;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DatabeanBufferConveyor<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends BaseConveyor {
    private static final int BATCH_SIZE = 100;
    private final DatabeanBuffer<PK, D> databeanBuffer;
    private final Consumer<Collection<D>> putMultiConsumer;

    public DatabeanBufferConveyor(String name, Supplier<Boolean> shouldRun, DatabeanBuffer<PK, D> databeanBuffer, Consumer<Collection<D>> putMultiConsumer) {
        super(name, shouldRun, () -> false);
        this.databeanBuffer = databeanBuffer;
        this.putMultiConsumer = putMultiConsumer;
    }

    @Override
    public BaseConveyor.ProcessBatchResult processBatch() {
        List<Databean> databeans = this.databeanBuffer.pollMultiWithLimit(100);
        if (databeans.isEmpty()) {
            return new BaseConveyor.ProcessBatchResult(false);
        }
        try {
            this.putMultiConsumer.accept(databeans);
            ConveyorCounters.incPutMultiOpAndDatabeans(this, databeans.size());
            return new BaseConveyor.ProcessBatchResult(true);
        }
        catch (Exception putMultiException) {
            databeans.forEach(this.databeanBuffer::offer);
            ConveyorCounters.inc(this, "putMulti exception", 1L);
            return new BaseConveyor.ProcessBatchResult(false);
        }
    }
}

