/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import io.datarouter.enums.IntegerEnum;
import io.datarouter.enums.Java9;
import io.datarouter.enums.PersistentString;
import io.datarouter.enums.StringEnum;
import io.datarouter.enums.Validated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DatarouterEnumTool {
    public static <T extends IntegerEnum<T>> int compareIntegerEnums(T valueA, T valueB) {
        if (DatarouterEnumTool.bothNull(valueA, valueB)) {
            return 0;
        }
        if (DatarouterEnumTool.isOneNullButNotTheOther(valueA, valueB)) {
            return valueA == null ? -1 : 1;
        }
        return DatarouterEnumTool.nullFirstCompareTo(valueA.getPersistentInteger(), valueB.getPersistentInteger());
    }

    public static <T extends StringEnum<T>> int compareStringEnums(T valueA, T valueB) {
        if (DatarouterEnumTool.bothNull(valueA, valueB)) {
            return 0;
        }
        if (DatarouterEnumTool.isOneNullButNotTheOther(valueA, valueB)) {
            return valueA == null ? -1 : 1;
        }
        return DatarouterEnumTool.nullFirstCompareTo(valueA.getPersistentString(), valueB.getPersistentString());
    }

    public static <T extends IntegerEnum<T>> T getEnumFromInteger(T[] values, Integer value, T defaultEnum) {
        return DatarouterEnumTool.findEnumFromInteger(values, (Integer)value).orElse(defaultEnum);
    }

    public static <T extends IntegerEnum<T>> Optional<T> findEnumFromInteger(T[] values, Integer value) {
        if (value == null) {
            return Optional.empty();
        }
        return Arrays.stream(values).filter(type -> type.getPersistentInteger().equals(value)).findFirst();
    }

    public static <T extends PersistentString> T getEnumFromString(T[] values, String value, T defaultEnum, boolean caseSensitive) {
        return DatarouterEnumTool.findEnumFromString(values, (String)value, (boolean)caseSensitive).orElse(defaultEnum);
    }

    public static <T extends PersistentString> T getEnumFromString(T[] values, String value, T defaultEnum) {
        return DatarouterEnumTool.findEnumFromString(values, (String)value, (boolean)true).orElse(defaultEnum);
    }

    public static <T extends PersistentString> Optional<T> findEnumFromString(T[] values, String value) {
        return DatarouterEnumTool.findEnumFromString(values, (String)value, (boolean)true);
    }

    public static <T extends PersistentString> Optional<T> findEnumFromString(T[] values, String value, boolean caseSensitive) {
        if (value == null) {
            return Optional.empty();
        }
        return Arrays.stream(values).filter(enumEntry -> enumEntry.getPersistentString() != null).filter(enumEntry -> {
            String persistentString = enumEntry.getPersistentString();
            if (caseSensitive) {
                return persistentString.equals(value);
            }
            return persistentString.equalsIgnoreCase(value);
        }).findFirst();
    }

    public static <E extends StringEnum<E>> List<String> getPersistentStrings(Collection<E> enums) {
        if (enums == null) {
            return Java9.listOf(new String[0]);
        }
        return enums.stream().map(PersistentString::getPersistentString).collect(Collectors.toList());
    }

    public static <E extends StringEnum<E>> List<E> fromPersistentStrings(E enumInstance, Collection<String> persistentStrings) {
        if (persistentStrings == null) {
            return Java9.listOf(new StringEnum[0]);
        }
        return persistentStrings.stream().map(enumInstance::fromPersistentString).collect(Collectors.toList());
    }

    public static <E extends StringEnum<E>> Validated<List<E>> uniqueListFromCsvNames(E[] values, String csvNames, boolean defaultAll) {
        int n;
        LinkedHashSet result = new LinkedHashSet();
        Validated<List<E>> validated = new Validated<List<E>>();
        if (DatarouterEnumTool.notEmpty(csvNames)) {
            String[] types;
            String[] stringArray = types = csvNames.split("[,\\s]+");
            int n2 = types.length;
            n = 0;
            while (n < n2) {
                String name = stringArray[n];
                if (!DatarouterEnumTool.isEmpty(name)) {
                    StringEnum type = (StringEnum)DatarouterEnumTool.getEnumFromString(values, (String)name, null, (boolean)false);
                    if (type == null) {
                        validated.addError(name);
                    } else {
                        result.add(type);
                    }
                }
                ++n;
            }
        }
        if (result.isEmpty()) {
            if (defaultAll) {
                E[] EArray = values;
                n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    E e = EArray[n3];
                    result.add(e);
                    ++n3;
                }
            } else {
                validated.addError("No value found");
            }
        }
        ArrayList listResult = new ArrayList();
        listResult.addAll(result);
        validated.set(listResult);
        return validated;
    }

    private static boolean notEmpty(String input) {
        return input != null && input.length() > 0;
    }

    private static boolean isEmpty(String input) {
        return input == null || input.isEmpty();
    }

    private static boolean bothNull(Object first, Object second) {
        return first == null && second == null;
    }

    private static boolean isOneNullButNotTheOther(Object first, Object second) {
        return first == null ^ second == null;
    }

    private static <T extends Comparable<? super T>> int nullFirstCompareTo(T object1, T object2) {
        if (object1 == null && object2 == null) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object1.compareTo(object2);
    }

    public static class IntegerEnumComparator<T extends IntegerEnum<T>>
    implements Comparator<T> {
        @Override
        public int compare(T valueA, T valueB) {
            if (DatarouterEnumTool.bothNull(valueA, valueB)) {
                return 0;
            }
            if (DatarouterEnumTool.isOneNullButNotTheOther(valueA, valueB)) {
                return valueA == null ? -1 : 1;
            }
            return DatarouterEnumTool.nullFirstCompareTo(valueA.getPersistentInteger(), valueB.getPersistentInteger());
        }
    }
}

