/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import java.util.Optional;

public interface IntegerEnum<E>
extends Comparable<E> {
    public Integer getPersistentInteger();

    public E fromPersistentInteger(Integer var1);

    default public Optional<E> fromPersistentIntegerOptional(Integer value) {
        return Optional.ofNullable(this.fromPersistentInteger(value));
    }

    public static <E extends IntegerEnum<E>> E fromPersistentIntegerSafe(E sampleValue, Integer persistentInteger) {
        if (persistentInteger == null) {
            return null;
        }
        IntegerEnum enumValue = (IntegerEnum)sampleValue.fromPersistentInteger(persistentInteger);
        if (enumValue == null || !persistentInteger.equals(enumValue.getPersistentInteger())) {
            String message = String.format("%s.fromPersistentInteger returned %s instead of %s", sampleValue.getClass().getSimpleName(), enumValue == null ? "null" : enumValue.getPersistentInteger(), persistentInteger);
            throw new RuntimeException(message);
        }
        return (E)enumValue;
    }
}

