/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class MappedEnum<K, E> {
    private final E sampleValue;
    private final Map<K, E> valueByKey;

    public MappedEnum(E[] values, Function<E, K> keyExtractor) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have 1 or more values");
        }
        this.sampleValue = values[0];
        Objects.requireNonNull(keyExtractor);
        this.valueByKey = MappedEnum.byUniqueKey(values, keyExtractor);
    }

    public E getOrDefault(K key, E defaultValue) {
        return this.valueByKey.getOrDefault(key, defaultValue);
    }

    public E getOrThrow(K key) {
        E value = this.valueByKey.get(key);
        if (value == null) {
            String message = String.format("key=%s does not exist for enum=%s", key, this.sampleValue.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public Optional<E> find(K key) {
        return Optional.ofNullable(this.valueByKey.get(key));
    }

    private static <E, K> Map<K, E> byUniqueKey(E[] values, Function<E, K> keyExtractor) {
        HashMap<K, E> map = new HashMap<K, E>();
        E[] EArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            E value = EArray[n2];
            K key = keyExtractor.apply(value);
            if (map.containsKey(key)) {
                String message = String.format("key=%s already exists with value=%s", key, value);
                throw new IllegalArgumentException(message);
            }
            map.put(key, value);
            ++n2;
        }
        return Collections.unmodifiableMap(map);
    }
}

