/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import io.datarouter.enums.PersistentString;
import java.util.Optional;

public interface StringEnum<E>
extends Comparable<E>,
PersistentString {
    public E fromPersistentString(String var1);

    default public Optional<E> fromPersistentStringOptional(String string) {
        return Optional.ofNullable(this.fromPersistentString(string));
    }

    public static <E extends StringEnum<E>> E fromPersistentStringSafe(E sampleValue, String persistentString) {
        if (persistentString == null) {
            return null;
        }
        StringEnum enumValue = (StringEnum)sampleValue.fromPersistentString(persistentString);
        if (enumValue == null || !persistentString.equals(enumValue.getPersistentString())) {
            String message = String.format("%s.fromPersistentString returned %s instead of %s", sampleValue.getClass().getSimpleName(), enumValue == null ? "null" : enumValue.getPersistentString(), persistentString);
            throw new RuntimeException(message);
        }
        return (E)enumValue;
    }
}

