/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums.web;

import io.datarouter.enums.Displayable;
import io.datarouter.enums.DisplayablePersistentString;
import io.datarouter.enums.web.HtmlSelectOptionBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class EnumTool {
    public static List<HtmlSelectOptionBean> getHtmlSelectOptions(Iterable<? extends DisplayablePersistentString> values) {
        return EnumTool.getHtmlSelectOptions(values, Collections.emptyList());
    }

    public static List<HtmlSelectOptionBean> getHtmlSelectOptions(DisplayablePersistentString[] values, String ... ignoredValues) {
        return EnumTool.getHtmlSelectOptions(Arrays.asList(values), Arrays.asList(ignoredValues));
    }

    private static List<HtmlSelectOptionBean> getHtmlSelectOptions(Iterable<? extends DisplayablePersistentString> values, Collection<String> ignoredValues) {
        ArrayList<HtmlSelectOptionBean> options = new ArrayList<HtmlSelectOptionBean>();
        for (DisplayablePersistentString displayablePersistentString : values) {
            if (ignoredValues.contains(displayablePersistentString.getPersistentString())) continue;
            options.add(new HtmlSelectOptionBean(displayablePersistentString.getDisplay(), displayablePersistentString.getPersistentString()));
        }
        return options;
    }

    public static <T extends Displayable> T getEnumFromDisplay(T[] values, String display, T defaultEnum) {
        if (display == null) {
            return defaultEnum;
        }
        return (T)Stream.of(values).filter(type -> type.getDisplay().equalsIgnoreCase(display)).findFirst().orElse(defaultEnum);
    }

    public static <T extends Enum<?>> T getEnumFromName(T[] values, String name, T defaultEnum) {
        if (name == null) {
            return defaultEnum;
        }
        return (T)Stream.of(values).filter(type -> type.name().equalsIgnoreCase(name)).findFirst().orElse(defaultEnum);
    }
}

