/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class MappedEnum<E, K> {
    private final E sampleValue;
    private final Class<E> enumClass;
    private final Function<E, K> keyExtractor;
    private final Function<K, K> keyTransformer;
    private final Map<K, E> valueByKey;

    public MappedEnum(E[] values, Function<E, K> keyExtractor) {
        this(values, keyExtractor, Function.identity());
    }

    public MappedEnum(E[] values, Function<E, K> keyExtractor, Function<K, K> keyTransformer) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have 1 or more values");
        }
        this.sampleValue = values[0];
        this.enumClass = MappedEnum.extractEnumClass(this.sampleValue);
        this.keyExtractor = Objects.requireNonNull(keyExtractor);
        this.keyTransformer = Objects.requireNonNull(keyTransformer);
        this.valueByKey = MappedEnum.byUniqueTransformedKey(values, keyExtractor, keyTransformer);
    }

    public MappedEnum<E, K> requireAllExist(K ... keys) {
        return this.requireAllExist((Collection<K>)Arrays.asList(keys));
    }

    public MappedEnum<E, K> requireAllExist(Collection<K> keys) {
        keys.forEach(this::fromOrThrow);
        return this;
    }

    public K toKey(E enumValue) {
        return this.keyExtractor.apply(enumValue);
    }

    public Optional<E> from(K key) {
        Object transformedKey = Optional.ofNullable(key).map(this.keyTransformer::apply).orElse(null);
        return Optional.ofNullable(this.valueByKey.get(transformedKey));
    }

    public E fromOrNull(K key) {
        Object transformedKey = Optional.ofNullable(key).map(this.keyTransformer::apply).orElse(null);
        return this.valueByKey.get(transformedKey);
    }

    public E fromOrElse(K key, E defaultValue) {
        Objects.requireNonNull(defaultValue, "Use fromOrNull for null default value");
        Object transformedKey = Optional.ofNullable(key).map(this.keyTransformer::apply).orElse(null);
        return this.valueByKey.getOrDefault(transformedKey, defaultValue);
    }

    public E fromOrThrow(K key) {
        Object transformedKey = Optional.ofNullable(key).map(this.keyTransformer::apply).orElse(null);
        E value = this.valueByKey.get(transformedKey);
        if (value == null) {
            String message = String.format("key=%s, transformedKey=%s does not exist for enum=%s", key, transformedKey, this.sampleValue.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public E getSampleValue() {
        return this.sampleValue;
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    public Map<K, E> getValueByKey() {
        return this.valueByKey;
    }

    private static <E> Class<E> extractEnumClass(E sampleValue) {
        return sampleValue.getClass();
    }

    private static <E, K> Map<K, E> byUniqueTransformedKey(E[] values, Function<E, K> keyExtractor, Function<K, K> keyTransformer) {
        HashMap<K, E> map = new HashMap<K, E>();
        E[] EArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            E value = EArray[n2];
            K key = keyExtractor.apply(value);
            K transformedKey = keyTransformer.apply(key);
            if (map.containsKey(key)) {
                String message = String.format("transformedKey=%s already exists with value=%s", transformedKey, value);
                throw new IllegalArgumentException(message);
            }
            map.put(transformedKey, value);
            ++n2;
        }
        return Collections.unmodifiableMap(map);
    }
}

