/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.enums;

import io.datarouter.enums.MappedEnum;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StringMappedEnum<E>
extends MappedEnum<E, String> {
    private final int maxLength;

    public StringMappedEnum(E[] values, Function<E, String> keyExtractor) {
        this(values, keyExtractor, Integer.MAX_VALUE);
    }

    public StringMappedEnum(E[] values, Function<E, String> keyExtractor, int maxLength) {
        super(values, keyExtractor);
        this.maxLength = maxLength;
        StringMappedEnum.validateLengths(this.getValueByKey().keySet(), maxLength);
    }

    public int maxLength() {
        return this.maxLength;
    }

    private static final void validateLengths(Collection<String> strings, int maxLength) {
        List tooLong = strings.stream().filter(str -> str.length() > maxLength).collect(Collectors.toList());
        if (!tooLong.isEmpty()) {
            String message = String.format("Some entries (%s) exceed the max length=%s", tooLong, maxLength);
            throw new IllegalArgumentException(message);
        }
    }
}

