/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.config;

import io.datarouter.conveyor.ConveyorConfigurationGroup;
import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.config.DatarouterExceptionRouteSet;
import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.config.DatarouterExceptionTriggerGroup;
import io.datarouter.exception.conveyors.ExceptionConveyorConfigurationGroup;
import io.datarouter.exception.filter.GuiceExceptionHandlingFilter;
import io.datarouter.exception.service.DatarouterExceptionPublisherService;
import io.datarouter.exception.service.DefaultExceptionHandlingConfig;
import io.datarouter.exception.service.DefaultExceptionRecorder;
import io.datarouter.exception.service.ExceptionGraphLink;
import io.datarouter.exception.service.ExceptionRecordAggregationDailyDigest;
import io.datarouter.exception.service.IssueLinkPrefixService;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordDao;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordQueueDao;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordDao;
import io.datarouter.exception.storage.httprecord.HttpRequestRecordQueueDao;
import io.datarouter.exception.storage.taskexecutorrecord.TaskExecutorRecordDirectorySupplier;
import io.datarouter.exception.storage.taskexecutorrecord.TaskExecutorRecordQueueDao;
import io.datarouter.exception.utils.nameparser.ExceptionNameParserRegistry;
import io.datarouter.instrumentation.exception.DatarouterExceptionPublisher;
import io.datarouter.instrumentation.exception.ExceptionRecordSummaryCollector;
import io.datarouter.job.BaseTriggerGroup;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.config.DatarouterWebPlugin;
import io.datarouter.web.dispatcher.FilterParamGrouping;
import io.datarouter.web.dispatcher.FilterParams;
import io.datarouter.web.exception.ExceptionHandlingConfig;
import io.datarouter.web.exception.ExceptionRecorder;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.ArrayList;
import java.util.List;

public class DatarouterExceptionPlugin
extends BaseWebPlugin {
    private final Class<? extends ExceptionGraphLink> exceptionGraphLinkClass;
    private final Class<? extends ExceptionRecorder> exceptionRecorderClass;
    private final Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass;
    private final Class<? extends DatarouterExceptionPublisher> exceptionRecordPublisher;
    private final Class<? extends TaskExecutorRecordDirectorySupplier> taskExecutorRecordDirectorySupplier;
    private final Class<? extends ExceptionRecordSummaryCollector> exceptionRecordSummaryCollectorClass;
    private final Class<? extends IssueLinkPrefixService> issueLinkPrefixService;
    private final Class<? extends ExceptionNameParserRegistry> exceptionNameParserRegistryClass;

    private DatarouterExceptionPlugin(DatarouterExceptionDaoModule daosModuleBuilder, Class<? extends ExceptionGraphLink> exceptionGraphLinkClass, Class<? extends ExceptionRecorder> exceptionRecorderClass, Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass, Class<? extends DatarouterExceptionPublisher> exceptionRecordPublisher, Class<? extends TaskExecutorRecordDirectorySupplier> taskExecutorRecordDirectorySupplier, Class<? extends ExceptionRecordSummaryCollector> exceptionRecordSummaryCollectorClass, Class<? extends IssueLinkPrefixService> issueLinkPrefixService, Class<? extends ExceptionNameParserRegistry> exceptionNameParserRegistryClass) {
        this.exceptionGraphLinkClass = exceptionGraphLinkClass;
        this.exceptionRecorderClass = exceptionRecorderClass;
        this.exceptionHandlingConfigClass = exceptionHandlingConfigClass;
        this.exceptionRecordPublisher = exceptionRecordPublisher;
        this.taskExecutorRecordDirectorySupplier = taskExecutorRecordDirectorySupplier;
        this.exceptionRecordSummaryCollectorClass = exceptionRecordSummaryCollectorClass;
        this.issueLinkPrefixService = issueLinkPrefixService;
        this.exceptionNameParserRegistryClass = exceptionNameParserRegistryClass;
        this.addFilterParamsOrdered(new FilterParams(false, "/*", GuiceExceptionHandlingFilter.class, FilterParamGrouping.DATAROUTER), DatarouterWebPlugin.REQUEST_CACHING_FILTER_PARAMS);
        this.addRouteSet(DatarouterExceptionRouteSet.class);
        this.addSettingRoot(DatarouterExceptionSettingRoot.class);
        this.addPluginEntry(BaseTriggerGroup.KEY, DatarouterExceptionTriggerGroup.class);
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.MONITORING, new DatarouterExceptionPaths().datarouter.exception.details, "Exceptions");
        this.addDatarouterGithubDocLink("datarouter-exception");
        if (!exceptionRecordPublisher.isInstance(DatarouterExceptionPublisher.NoOpDatarouterExceptionPublisher.class)) {
            this.addPluginEntry(ConveyorConfigurationGroup.KEY, ExceptionConveyorConfigurationGroup.class);
        }
        this.addDailyDigest(ExceptionRecordAggregationDailyDigest.class);
    }

    protected void configure() {
        this.bindDefault(ExceptionGraphLink.class, this.exceptionGraphLinkClass);
        this.bindActual(ExceptionRecorder.class, this.exceptionRecorderClass);
        this.bindActual(ExceptionHandlingConfig.class, this.exceptionHandlingConfigClass);
        this.bind(DatarouterExceptionPublisher.class).to(this.exceptionRecordPublisher);
        this.bind(TaskExecutorRecordDirectorySupplier.class).to(this.taskExecutorRecordDirectorySupplier);
        this.bind(ExceptionRecordSummaryCollector.class).to(this.exceptionRecordSummaryCollectorClass);
        this.bind(IssueLinkPrefixService.class).to(this.issueLinkPrefixService);
        this.bind(ExceptionNameParserRegistry.class).to(this.exceptionNameParserRegistryClass);
    }

    public static class DatarouterExceptionDaoModule
    extends DaosModuleBuilder {
        private final List<ClientId> datarouterExceptionRecordClientId;
        private final List<ClientId> datarouterHttpRequestRecordClientId;
        private final List<ClientId> queueClientIds;

        public DatarouterExceptionDaoModule(List<ClientId> defaultClientIds, List<ClientId> blobQueueClientIds) {
            this(defaultClientIds, defaultClientIds, blobQueueClientIds);
        }

        public DatarouterExceptionDaoModule(List<ClientId> datarouterExceptionRecordClientId, List<ClientId> datarouterHttpRequestRecordClientId, List<ClientId> blobQueueClientIds) {
            this.datarouterExceptionRecordClientId = datarouterExceptionRecordClientId;
            this.datarouterHttpRequestRecordClientId = datarouterHttpRequestRecordClientId;
            this.queueClientIds = blobQueueClientIds;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            ArrayList<Class<? extends Dao>> daos = new ArrayList<Class<? extends Dao>>();
            daos.add(DatarouterExceptionRecordDao.class);
            daos.add(DatarouterHttpRequestRecordDao.class);
            if (this.queueClientIds != null) {
                daos.add(ExceptionRecordQueueDao.class);
                daos.add(HttpRequestRecordQueueDao.class);
                daos.add(TaskExecutorRecordQueueDao.class);
            }
            return daos;
        }

        public void configure() {
            this.bind(DatarouterHttpRequestRecordDao.DatarouterHttpRequestRecordDaoParams.class).toInstance((Object)new DatarouterHttpRequestRecordDao.DatarouterHttpRequestRecordDaoParams(this.datarouterHttpRequestRecordClientId));
            this.bind(DatarouterExceptionRecordDao.DatarouterExceptionRecordDaoParams.class).toInstance((Object)new DatarouterExceptionRecordDao.DatarouterExceptionRecordDaoParams(this.datarouterExceptionRecordClientId));
            if (this.queueClientIds != null) {
                this.bind(ExceptionRecordQueueDao.ExceptionRecordQueueDaoParams.class).toInstance((Object)new ExceptionRecordQueueDao.ExceptionRecordQueueDaoParams(this.queueClientIds));
                this.bind(HttpRequestRecordQueueDao.HttpRequestRecordQueueDaoParams.class).toInstance((Object)new HttpRequestRecordQueueDao.HttpRequestRecordQueueDaoParams(this.queueClientIds));
                this.bind(TaskExecutorRecordQueueDao.TaskExecutorRecordQueueDaoParams.class).toInstance((Object)new TaskExecutorRecordQueueDao.TaskExecutorRecordQueueDaoParams(this.queueClientIds));
            }
        }
    }

    public static class DatarouterExceptionPluginBuilder {
        private final List<ClientId> defaultClientIds;
        private List<ClientId> blobQueueClientIds;
        private Class<? extends ExceptionGraphLink> exceptionGraphLinkClass = ExceptionGraphLink.NoOpExceptionGraphLink.class;
        private Class<? extends ExceptionRecorder> exceptionRecorderClass = DefaultExceptionRecorder.class;
        private Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass = DefaultExceptionHandlingConfig.class;
        private Class<? extends DatarouterExceptionPublisher> exceptionRecordPublisher = DatarouterExceptionPublisher.NoOpDatarouterExceptionPublisher.class;
        private Class<? extends TaskExecutorRecordDirectorySupplier> taskExecutorRecordDirectorySupplier = TaskExecutorRecordDirectorySupplier.NoOpTaskExecutorRecordDirectorySupplier.class;
        private Class<? extends ExceptionRecordSummaryCollector> exceptionRecordSummaryCollector = ExceptionRecordSummaryCollector.NoOpExceptionRecordSummaryCollector.class;
        private Class<? extends IssueLinkPrefixService> issueLinkPrefixService = IssueLinkPrefixService.NoOpIssueLinkPrefixService.class;
        private Class<? extends ExceptionNameParserRegistry> exceptionNameParserRegistryClass = ExceptionNameParserRegistry.NoOpExceptionNameParserRegistry.class;

        public DatarouterExceptionPluginBuilder(List<ClientId> defaultClientIds) {
            this.defaultClientIds = defaultClientIds;
        }

        public DatarouterExceptionPluginBuilder setExceptionGraphLinkClass(Class<? extends ExceptionGraphLink> exceptionGraphLinkClass) {
            this.exceptionGraphLinkClass = exceptionGraphLinkClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExceptionRecorderClass(Class<? extends ExceptionRecorder> exceptionRecorderClass) {
            this.exceptionRecorderClass = exceptionRecorderClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExceptionHandlingClass(Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass) {
            this.exceptionHandlingConfigClass = exceptionHandlingConfigClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExceptionRecordSummaryCollector(Class<? extends ExceptionRecordSummaryCollector> exceptionRecordSummaryCollector) {
            this.exceptionRecordSummaryCollector = exceptionRecordSummaryCollector;
            return this;
        }

        public DatarouterExceptionPluginBuilder enablePublishing(List<ClientId> blobQueueClientIds, Class<? extends TaskExecutorRecordDirectorySupplier> taskExecutorRecordDirectorySupplier) {
            this.exceptionRecordPublisher = DatarouterExceptionPublisherService.class;
            this.blobQueueClientIds = blobQueueClientIds;
            this.taskExecutorRecordDirectorySupplier = taskExecutorRecordDirectorySupplier;
            return this;
        }

        public DatarouterExceptionPluginBuilder withIssueLinkPrefixService(Class<? extends IssueLinkPrefixService> issueLinkPrefixService) {
            this.issueLinkPrefixService = issueLinkPrefixService;
            return this;
        }

        public DatarouterExceptionPluginBuilder withExceptionNameParserRegistryClass(Class<? extends ExceptionNameParserRegistry> exceptionNameParserRegistryClass) {
            this.exceptionNameParserRegistryClass = exceptionNameParserRegistryClass;
            return this;
        }

        public DatarouterExceptionPlugin build() {
            return new DatarouterExceptionPlugin(new DatarouterExceptionDaoModule(this.defaultClientIds, this.blobQueueClientIds), this.exceptionGraphLinkClass, this.exceptionRecorderClass, this.exceptionHandlingConfigClass, this.exceptionRecordPublisher, this.taskExecutorRecordDirectorySupplier, this.exceptionRecordSummaryCollector, this.issueLinkPrefixService, this.exceptionNameParserRegistryClass);
        }
    }
}

