/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.conveyors;

import io.datarouter.conveyor.Conveyor;
import io.datarouter.conveyor.ConveyorConfiguration;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.ConveyorGauges;
import io.datarouter.conveyor.ConveyorRunnable;
import io.datarouter.exception.conveyors.DatarouterExceptionBuffers;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.instrumentation.exception.DatarouterExceptionPublisher;
import io.datarouter.instrumentation.exception.ExceptionRecordBatchDto;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.scanner.Scanner;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExceptionRecordMemoryToPublisherConveyorConfiguration
implements ConveyorConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionRecordMemoryToPublisherConveyorConfiguration.class);
    private static final int BATCH_SIZE = 10000;
    @Inject
    private DatarouterExceptionBuffers buffers;
    @Inject
    private DatarouterExceptionPublisher exceptionRecordPublisher;
    @Inject
    private ConveyorGauges gaugeRecorder;

    public Conveyor.ProcessResult process(ConveyorRunnable conveyor) {
        Instant beforePeek = Instant.now();
        ExceptionRecordBatchDto batch = (ExceptionRecordBatchDto)Scanner.of((Iterable)this.buffers.exceptionRecordPublishingBuffer.pollMultiWithLimit(10000)).map(ExceptionRecord::toDto).listTo(ExceptionRecordBatchDto::new);
        Instant afterPeek = Instant.now();
        this.gaugeRecorder.savePeekDurationMs(conveyor, Duration.between(beforePeek, afterPeek).toMillis());
        TracerTool.setAlternativeStartTime();
        if (batch.records().isEmpty()) {
            return new Conveyor.ProcessResult(false);
        }
        try {
            this.exceptionRecordPublisher.addExceptionRecord(batch);
            ConveyorCounters.incPutMultiOpAndDatabeans((ConveyorRunnable)conveyor, (long)batch.records().size());
            return new Conveyor.ProcessResult(batch.records().size() == 10000);
        }
        catch (Exception putMultiException) {
            logger.warn("", (Throwable)putMultiException);
            ConveyorCounters.inc((ConveyorRunnable)conveyor, (String)"putMulti exception", (long)1L);
            return new Conveyor.ProcessResult(true);
        }
    }

    public boolean shouldRunOnShutdown() {
        return true;
    }

    public Duration delay() {
        return Duration.ofSeconds(10L);
    }
}

