/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.conveyors;

import io.datarouter.conveyor.Conveyor;
import io.datarouter.conveyor.ConveyorConfiguration;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.ConveyorGauges;
import io.datarouter.conveyor.ConveyorRunnable;
import io.datarouter.exception.conveyors.DatarouterExceptionBuffers;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.instrumentation.exception.DatarouterExceptionPublisher;
import io.datarouter.instrumentation.exception.HttpRequestRecordBatchDto;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.scanner.Scanner;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpRequestRecordMemoryToPublisherConveyorConfiguration
implements ConveyorConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestRecordMemoryToPublisherConveyorConfiguration.class);
    private static final int BATCH_SIZE = 500;
    @Inject
    private DatarouterExceptionBuffers buffers;
    @Inject
    private DatarouterExceptionPublisher exceptionRecordPublisher;
    @Inject
    private ConveyorGauges gaugeRecorder;

    public Conveyor.ProcessResult process(ConveyorRunnable conveyor) {
        Instant beforePeek = Instant.now();
        HttpRequestRecordBatchDto batch = (HttpRequestRecordBatchDto)Scanner.of((Iterable)this.buffers.httpRequestRecordPublishingBuffer.pollMultiWithLimit(500)).map(HttpRequestRecord::toDto).listTo(HttpRequestRecordBatchDto::new);
        Instant afterPeek = Instant.now();
        this.gaugeRecorder.savePeekDurationMs(conveyor, Duration.between(beforePeek, afterPeek).toMillis());
        TracerTool.setAlternativeStartTime();
        if (batch.records().isEmpty()) {
            return new Conveyor.ProcessResult(false);
        }
        try {
            this.exceptionRecordPublisher.addHttpRequestRecord(batch);
            ConveyorCounters.incPutMultiOpAndDatabeans((ConveyorRunnable)conveyor, (long)batch.records().size());
            return new Conveyor.ProcessResult(batch.records().size() == 500);
        }
        catch (Exception putMultiException) {
            logger.warn("", (Throwable)putMultiException);
            ConveyorCounters.inc((ConveyorRunnable)conveyor, (String)"putMulti exception", (long)1L);
            return new Conveyor.ProcessResult(true);
        }
    }

    public boolean shouldRunOnShutdown() {
        return true;
    }
}

