/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.dto;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.binarydto.dto.BinaryDto;
import io.datarouter.binarydto.dto.BinaryDtoField;
import io.datarouter.exception.dto.TaskExecutionRecordBinaryDto;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.util.Require;
import java.time.Instant;
import java.util.Date;
import java.util.List;

public class ExceptionRecordBinaryDto
extends BinaryDto<ExceptionRecordBinaryDto>
implements TaskExecutionRecordBinaryDto<ExceptionRecordDto> {
    @BinaryDtoField(index=0)
    public final String serviceName;
    @BinaryDtoField(index=1)
    public final String serverName;
    @BinaryDtoField(index=2)
    public final String appVersion;
    @BinaryDtoField(index=3)
    public final String id;
    @BinaryDtoField(index=4)
    public final Instant created;
    @BinaryDtoField(index=5)
    public final String category;
    @BinaryDtoField(index=6)
    public final String name;
    @BinaryDtoField(index=7)
    public final String stackTrace;
    @BinaryDtoField(index=8)
    public final String type;
    @BinaryDtoField(index=9)
    public final String exceptionLocation;
    @BinaryDtoField(index=10)
    public final String methodName;
    @BinaryDtoField(index=11)
    public final Integer lineNumber;
    @BinaryDtoField(index=12)
    public final String callOrigin;
    @BinaryDtoField(index=13)
    public final List<String> additionalAlertRecipients;

    public ExceptionRecordBinaryDto(String serviceName, String serverName, String appVersion, String id, Date created, String category, String name, String stackTrace, String type, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin, List<String> additionalAlertRecipients) {
        this.serviceName = Require.notBlank((String)serviceName);
        this.serverName = Require.notBlank((String)serverName);
        this.appVersion = Require.notBlank((String)appVersion);
        this.id = id;
        this.created = created == null ? null : created.toInstant();
        this.category = category;
        this.name = name;
        this.stackTrace = stackTrace;
        this.type = type;
        this.exceptionLocation = exceptionLocation;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
        this.callOrigin = callOrigin;
        this.additionalAlertRecipients = additionalAlertRecipients;
    }

    public ExceptionRecordBinaryDto(ExceptionRecordDto dto) {
        this(dto.serviceName(), dto.serverName(), dto.appVersion(), dto.id(), dto.created(), dto.category(), dto.name(), dto.stackTrace(), dto.type(), dto.exceptionLocation(), dto.methodName(), dto.lineNumber(), dto.callOrigin(), dto.additionalAlertRecipients());
    }

    @Override
    public ExceptionRecordDto toDto() {
        return new ExceptionRecordDto(this.id, this.created == null ? null : Date.from(this.created), this.serviceName, this.serverName, this.category, this.name, this.stackTrace, this.type, this.appVersion, this.exceptionLocation, this.methodName, this.lineNumber, this.callOrigin, this.additionalAlertRecipients);
    }

    public static ExceptionRecordBinaryDto decode(byte[] bytes) {
        return (ExceptionRecordBinaryDto)BinaryDtoIndexedCodec.of(ExceptionRecordBinaryDto.class).decode(bytes);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }
}

