/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.dto.ExceptionRecordBinaryDto;
import io.datarouter.exception.dto.HttpRequestRecordBinaryDto;
import io.datarouter.exception.dto.TaskExecutorRecordBinaryDto;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordQueueDao;
import io.datarouter.exception.storage.httprecord.HttpRequestRecordQueueDao;
import io.datarouter.exception.storage.taskexecutorrecord.TaskExecutorRecordDirectoryDao;
import io.datarouter.exception.storage.taskexecutorrecord.TaskExecutorRecordQueueDao;
import io.datarouter.instrumentation.exception.DatarouterExceptionPublisher;
import io.datarouter.instrumentation.exception.ExceptionRecordBatchDto;
import io.datarouter.instrumentation.exception.HttpRequestRecordBatchDto;
import io.datarouter.instrumentation.exception.HttpRequestRecordDto;
import io.datarouter.instrumentation.exception.TaskExecutorRecordDto;
import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.types.Ulid;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterExceptionPublisherService
implements DatarouterExceptionPublisher {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterExceptionPublisherService.class);
    private final DatarouterExceptionSettingRoot exceptionSettings;
    private final ExceptionRecordQueueDao exceptionRecordQueueDao;
    private final HttpRequestRecordQueueDao httpRequestRecordQueueDao;
    private final TaskExecutorRecordDirectoryDao taskExecutorRecordDirectoryDao;
    private final TaskExecutorRecordQueueDao taskExecutorRecordQueueDao;
    private final ServiceName serviceName;

    @Inject
    public DatarouterExceptionPublisherService(DatarouterExceptionSettingRoot exceptionSettings, ExceptionRecordQueueDao exceptionRecordQueueDao, HttpRequestRecordQueueDao httpRequestRecordQueueDao, TaskExecutorRecordDirectoryDao taskExecutorRecordDirectoryDao, TaskExecutorRecordQueueDao taskExecutorRecordQueueDao, ServiceName serviceName) {
        this.exceptionSettings = exceptionSettings;
        this.exceptionRecordQueueDao = exceptionRecordQueueDao;
        this.httpRequestRecordQueueDao = httpRequestRecordQueueDao;
        this.taskExecutorRecordDirectoryDao = taskExecutorRecordDirectoryDao;
        this.taskExecutorRecordQueueDao = taskExecutorRecordQueueDao;
        this.serviceName = serviceName;
    }

    public PublishingResponseDto addExceptionRecord(ExceptionRecordBatchDto exceptionRecordBatchDto) {
        if (exceptionRecordBatchDto.records().isEmpty()) {
            return PublishingResponseDto.SUCCESS;
        }
        logger.info("writing size={} exceptionRecords to {}", (Object)exceptionRecordBatchDto.records().size(), (Object)"queue");
        Scanner.of((Iterable)exceptionRecordBatchDto.records()).map(ExceptionRecordBinaryDto::new).then(this.exceptionRecordQueueDao::combineAndPut);
        return PublishingResponseDto.SUCCESS;
    }

    public PublishingResponseDto addHttpRequestRecord(HttpRequestRecordBatchDto httpRequestRecordBatchDto) {
        if (httpRequestRecordBatchDto.records().isEmpty()) {
            return PublishingResponseDto.SUCCESS;
        }
        logger.info("writing size={} httpRequestRecords to {}", (Object)httpRequestRecordBatchDto.records().size(), (Object)"queue");
        Scanner.of((Iterable)httpRequestRecordBatchDto.records()).map(dto -> new HttpRequestRecordBinaryDto((HttpRequestRecordDto)dto, this.serviceName.get())).then(this.httpRequestRecordQueueDao::combineAndPut);
        return PublishingResponseDto.SUCCESS;
    }

    public PublishingResponseDto addTaskExecutorRecord(List<TaskExecutorRecordDto> taskExecutorRecords) {
        if (taskExecutorRecords.isEmpty()) {
            return PublishingResponseDto.SUCCESS;
        }
        boolean isQueue = (Boolean)this.exceptionSettings.saveTaskExecutorRecordsToQueueDaoInsteadOfDirectoryDao.get();
        logger.info("writing size={} httpRequestRecords to {}", (Object)taskExecutorRecords.size(), (Object)(isQueue ? "queue" : "directory"));
        if (isQueue) {
            Scanner.of(taskExecutorRecords).map(record -> new TaskExecutorRecordBinaryDto(this.serviceName.get(), (TaskExecutorRecordDto)record)).then(this.taskExecutorRecordQueueDao::combineAndPut);
            return PublishingResponseDto.SUCCESS;
        }
        Scanner.of(taskExecutorRecords).map(record -> new TaskExecutorRecordBinaryDto(this.serviceName.get(), (TaskExecutorRecordDto)record)).then(scanner -> this.taskExecutorRecordDirectoryDao.write(scanner, new Ulid()));
        return PublishingResponseDto.SUCCESS;
    }
}

