/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.service.ExceptionRecordService;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.exception.ExceptionHandlingConfig;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.DatarouterSession;
import io.datarouter.web.user.session.DatarouterSessionManager;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class DefaultExceptionHandlingConfig
implements ExceptionHandlingConfig {
    @Inject
    private DatarouterExceptionSettingRoot settings;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private ExceptionRecordService exceptionRecordService;

    public boolean shouldDisplayStackTrace(HttpServletRequest request, Throwable exception) {
        return (Boolean)this.settings.forceHideStackTrace.get() == false && this.canViewStackTrace(request);
    }

    protected boolean canViewStackTrace(HttpServletRequest request) {
        return this.isDevServer() || ((Collection)DatarouterSessionManager.getFromRequest((ServletRequest)request).map(DatarouterSession::getRoles).orElse(Collections.emptySet())).contains(DatarouterUserRole.DATAROUTER_MONITORING.getRole());
    }

    public String getHtmlErrorMessage(Exception exception) {
        return "Error";
    }

    public boolean isDevServer() {
        return this.serverTypeDetector.mightBeDevelopment();
    }

    public String buildExceptionLinkForCurrentServer(String exceptionRecordId) {
        return this.exceptionRecordService.buildExceptionLinkForCurrentServer(exceptionRecordId);
    }
}

