/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.conveyors.DatarouterExceptionBuffers;
import io.datarouter.exception.service.ExceptionRecordService;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.exception.utils.ExceptionDetailsDetector;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.exception.ExceptionCategory;
import io.datarouter.storage.exception.UnknownExceptionCategory;
import io.datarouter.web.app.WebappName;
import io.datarouter.web.config.DatarouterWebSettingRoot;
import io.datarouter.web.dispatcher.Dispatcher;
import io.datarouter.web.exception.ExceptionCounters;
import io.datarouter.web.exception.ExceptionRecorder;
import io.datarouter.web.exception.WebExceptionCategory;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.monitoring.GitProperties;
import io.datarouter.web.monitoring.exception.ExceptionAndHttpRequestDto;
import io.datarouter.web.user.session.CurrentSessionInfo;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.ExceptionTool;
import io.datarouter.web.util.RequestAttributeKey;
import io.datarouter.web.util.RequestAttributeTool;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionRecorder
implements ExceptionRecorder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionRecorder.class);
    @Inject
    private GitProperties gitProperties;
    @Inject
    private ExceptionRecordService exceptionRecordService;
    @Inject
    private ExceptionDetailsDetector exceptionDetailsDetector;
    @Inject
    private DatarouterWebSettingRoot datarouterWebSettingRoot;
    @Inject
    private CurrentSessionInfo currentSessionInfo;
    @Inject
    private WebappName webappName;
    @Inject
    private DatarouterExceptionSettingRoot settings;
    @Inject
    private DatarouterExceptionBuffers exceptionBuffers;
    @Inject
    private ServerName serverName;
    @Inject
    private ServiceName serviceName;

    public Optional<ExceptionRecordDto> tryRecordException(Throwable exception, String callOrigin) {
        return this.tryRecordException(exception, callOrigin, (ExceptionCategory)UnknownExceptionCategory.UNKNOWN);
    }

    public Optional<ExceptionRecordDto> tryRecordException(Throwable exception, String callOrigin, ExceptionCategory category) {
        return this.tryRecordException(exception, callOrigin, category, List.of());
    }

    public Optional<ExceptionRecordDto> tryRecordException(Throwable exception, String callOrigin, ExceptionCategory category, List<String> additionalEmailRecipients) {
        try {
            ExceptionDetailsDetector.ExceptionRecorderDetails exceptionDetails = this.exceptionDetailsDetector.detect(exception, callOrigin, (Set<String>)((Set)this.datarouterWebSettingRoot.stackTraceHighlights.get()));
            return Optional.of(this.recordException(exception, category, exceptionDetails.className, exceptionDetails.methodName, exceptionDetails.parsedName, exceptionDetails.type, exceptionDetails.lineNumber, callOrigin, additionalEmailRecipients));
        }
        catch (Exception e) {
            logger.warn("Exception while recording an exception", (Throwable)e);
            return Optional.empty();
        }
    }

    public ExceptionRecordDto recordException(Throwable exception, ExceptionCategory category, String location, String methodName, String name, String type, Integer lineNumber, String callOrigin) {
        return this.recordException(exception, category, location, methodName, name, type, lineNumber, callOrigin, List.of());
    }

    public ExceptionRecordDto recordException(Throwable exception, ExceptionCategory category, String location, String methodName, String name, String type, Integer lineNumber, String callOrigin, List<String> additionalEmailRecipients) {
        return this.recordException(category, location, methodName, name, type, lineNumber, callOrigin, ExceptionTool.getStackTraceAsString((Throwable)exception), additionalEmailRecipients);
    }

    private ExceptionRecordDto recordException(ExceptionCategory category, String location, String methodName, String name, String type, Integer lineNumber, String callOrigin, String stackTrace, List<String> additionalEmailRecipients) {
        if (callOrigin == null) {
            callOrigin = location;
        }
        ExceptionCounters.inc((String)category.name());
        ExceptionCounters.inc((String)(String.valueOf(category.name()) + " " + this.webappName));
        ExceptionCounters.inc((String)("name " + name));
        ExceptionCounters.inc((String)type);
        ExceptionCounters.inc((String)callOrigin);
        ExceptionCounters.inc((String)(String.valueOf(type) + " " + callOrigin));
        ExceptionRecord exceptionRecord = new ExceptionRecord(ExceptionRecordKey.generate(), System.currentTimeMillis(), this.serviceName.get(), this.serverName.get(), category.name(), Optional.ofNullable(name).orElse(ExceptionDetailsDetector.ExceptionRecorderDetails.getDefaultName(type, name, callOrigin)), stackTrace, type, this.gitProperties.getIdAbbrev().orElse("unknown"), location, methodName, lineNumber, callOrigin, additionalEmailRecipients);
        exceptionRecord.trimFields();
        this.exceptionBuffers.exceptionRecordBuffer.offer((Object)exceptionRecord);
        logger.warn("Exception recorded ({})", (Object)this.exceptionRecordService.buildExceptionLinkForCurrentServer(exceptionRecord));
        if (((Boolean)this.settings.publishRecords.get()).booleanValue()) {
            this.exceptionBuffers.exceptionRecordPublishingBuffer.offer((Object)exceptionRecord);
        }
        return exceptionRecord.toDto();
    }

    public Optional<ExceptionRecordDto> tryRecordExceptionAndHttpRequest(Throwable exception, String callOrigin, HttpServletRequest request) {
        try {
            ExceptionDetailsDetector.ExceptionRecorderDetails exceptionDetails = this.exceptionDetailsDetector.detect(exception, callOrigin, (Set<String>)((Set)this.datarouterWebSettingRoot.stackTraceHighlights.get()));
            return Optional.of(this.recordExceptionAndHttpRequest(exception, exceptionDetails.className, exceptionDetails.methodName, exceptionDetails.parsedName, exceptionDetails.type, exceptionDetails.lineNumber, request, callOrigin));
        }
        catch (Exception e) {
            logger.warn("Exception while recording an exception", (Throwable)e);
            return Optional.empty();
        }
    }

    public ExceptionRecordDto recordExceptionAndHttpRequest(Throwable exception, String location, String methodName, String name, String type, Integer lineNumber, HttpServletRequest request, String callOrigin) {
        ExceptionRecordDto exceptionRecord = this.recordException(exception, (ExceptionCategory)WebExceptionCategory.HTTP_REQUEST, location, methodName, name, type, lineNumber, callOrigin);
        this.recordHttpRequest(request, exceptionRecord, true);
        return exceptionRecord;
    }

    public ExceptionRecordDto recordExceptionAndHttpRequest(ExceptionAndHttpRequestDto exceptionDto, ExceptionCategory category) {
        ExceptionRecordDto exceptionRecordDto = this.recordException(category, exceptionDto.errorLocation, exceptionDto.methodName, exceptionDto.name, exceptionDto.errorClass, exceptionDto.lineNumber, exceptionDto.callOrigin, exceptionDto.stackTrace, List.of());
        this.recordHttpRequest(exceptionDto, exceptionRecordDto, true);
        return exceptionRecordDto;
    }

    public void recordHttpRequest(HttpServletRequest request) {
        this.recordHttpRequest(request, null, false);
    }

    private void recordHttpRequest(HttpServletRequest request, ExceptionRecordDto exceptionRecord, boolean publish) {
        Optional<String> userToken = this.currentSessionInfo.getSession((ServletRequest)request).map(Session::getUserToken);
        String userRoles = this.currentSessionInfo.getRoles((ServletRequest)request).toString();
        boolean omitPayload = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)Dispatcher.TRANSMITS_PII).orElse(false);
        HttpRequestRecord httpRequestRecord = new HttpRequestRecord(exceptionRecord == null ? null : exceptionRecord.id(), RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.TRACE_CONTEXT), request, userRoles, userToken.orElse(null), omitPayload);
        this.saveAndPublishHttpRequest(httpRequestRecord, publish);
    }

    private void recordHttpRequest(ExceptionAndHttpRequestDto exceptionDto, ExceptionRecordDto exceptionRecord, boolean publish) {
        HttpRequestRecord httpRequestRecord = new HttpRequestRecord(exceptionDto, exceptionRecord.id());
        this.saveAndPublishHttpRequest(httpRequestRecord, publish);
    }

    private void saveAndPublishHttpRequest(HttpRequestRecord httpRequestRecord, boolean publish) {
        httpRequestRecord.trimFields();
        this.exceptionBuffers.httpRequestRecordBuffer.offer((Object)httpRequestRecord);
        httpRequestRecord.trimBinaryBody(10000);
        if (publish && ((Boolean)this.settings.publishRecords.get()).booleanValue()) {
            this.exceptionBuffers.httpRequestRecordPublishingBuffer.offer((Object)httpRequestRecord);
        }
    }
}

