/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.instrumentation.exception.ExceptionRecordSummaryCollector;
import io.datarouter.instrumentation.exception.ExceptionRecordSummaryDto;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.time.LocalDateTimeTool;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.SmallTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletContext;

@Singleton
public class ExceptionRecordAggregationDailyDigest
implements DailyDigest {
    private static final int EXCEPTIONS_THRESHOLD = 100;
    @Inject
    private DatarouterExceptionPaths paths;
    @Inject
    private ServletContextSupplier contextSupplier;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private ExceptionRecordSummaryCollector recordSummaryCollector;
    @Inject
    private ServiceName serviceName;

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        H3Tag header = this.digestService.makeHeader("Exceptions", this.recordSummaryCollector.getBrowsePageLink(this.serviceName.get()).orElse(""));
        SmallTag description = TagCreator.small((String)"Aggregated for the current day (over 100)");
        List<ExceptionRecordSummaryDto> summaries = this.getExceptionSummaries(zoneId);
        if (summaries.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, this.makePageTableV2(summaries)}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        H3Tag header = this.digestService.makeHeader("Exceptions", this.recordSummaryCollector.getBrowsePageLink(this.serviceName.get()).orElse(""));
        SmallTag description = TagCreator.small((String)"Aggregated for the current day (over 100)");
        List<ExceptionRecordSummaryDto> summaries = this.getExceptionSummaries(zoneId);
        if (summaries.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, this.makeEmailTableV2(summaries)}));
    }

    public String getTitle() {
        return "Exception Records";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.HIGH;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.SUMMARY;
    }

    private List<ExceptionRecordSummaryDto> getExceptionSummaries(ZoneId zoneId) {
        Instant startOfDay = LocalDateTimeTool.atStartOfDay((ZoneId)zoneId);
        return this.recordSummaryCollector.getSummaries(startOfDay.toEpochMilli(), System.currentTimeMillis(), this.serviceName.get(), Optional.of(100));
    }

    private TableTag makePageTableV2(List<ExceptionRecordSummaryDto> rows) {
        return new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Name", ExceptionRecordSummaryDto::name).withHtmlColumn((DomContent)TagCreator.th((String)"Count").withStyle("text-align:right"), row -> this.makeNumericPageTableCell(row.numExceptions())).withHtmlColumn("Details", row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("far fa-file-alt")}).withClass("btn btn-link w-100 py-0")).withHref(String.valueOf(((ServletContext)this.contextSupplier.get()).getContextPath()) + this.makeExceptionRecordPathV2((ExceptionRecordSummaryDto)row))})).withCaption("Total " + rows.size()).build(rows);
    }

    private TableTag makeEmailTableV2(List<ExceptionRecordSummaryDto> rows) {
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Name", row -> this.digestService.makeATagLink(row.name(), this.makeExceptionRecordPathV2((ExceptionRecordSummaryDto)row)))).withColumn(J2HtmlEmailTable.J2HtmlEmailTableColumn.ofNumber((String)"Count", ExceptionRecordSummaryDto::numExceptions)).build(rows);
    }

    private TdTag makeNumericPageTableCell(long value) {
        return (TdTag)((TdTag)TagCreator.td((String)NumberFormatter.addCommas((Number)value)).attr("sorttable_customkey", (Object)value)).withStyle("text-align:right");
    }

    private String makeExceptionRecordPathV2(ExceptionRecordSummaryDto dto) {
        return String.valueOf(this.paths.datarouter.exception.details.toSlashedString()) + "?" + "exceptionRecord" + "=" + dto.sampleExceptionRecordId();
    }
}

