/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.web.config.ServletContextSupplier;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import javax.servlet.ServletContext;

@Singleton
public class ExceptionRecordService {
    @Inject
    private DatarouterExceptionPaths paths;
    @Inject
    private DatarouterExceptionSettingRoot settings;
    @Inject
    private ServletContextSupplier servletContext;

    public String buildExceptionLinkForCurrentServer(String exceptionRecordId) {
        String domainAndContext = this.buildDomainAndContext();
        return this.buildExceptionLink(domainAndContext, exceptionRecordId);
    }

    public String buildExceptionLinkForCurrentServer(ExceptionRecord exceptionRecord) {
        return this.buildExceptionLinkForCurrentServer(((ExceptionRecordKey)exceptionRecord.getKey()).getId());
    }

    public String buildDomainAndContext() {
        return String.valueOf((String)this.settings.exceptionRecorderDomainName.get()) + ((ServletContext)this.servletContext.get()).getContextPath();
    }

    public String buildExceptionLink(String domainAndContext, String exceptionRecordId) {
        return "https://" + domainAndContext + this.paths.datarouter.exception.details.toSlashedString() + "?exceptionRecord=" + exceptionRecordId;
    }

    public String buildExceptionFormAction(String domainAndContext) {
        return "https://" + domainAndContext + this.paths.datarouter.exception.details.toSlashedString();
    }
}

