/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage;

import io.datarouter.binarydto.dto.BaseBinaryDto;
import io.datarouter.binarydto.dto.BinaryDto;
import io.datarouter.bytes.varint.VarIntByteArraysTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import io.datarouter.types.Ulid;

public abstract class BaseRecordDirectoryDao<E extends BinaryDto<?>> {
    protected abstract Directory getDirectory();

    protected abstract E decode(byte[] var1);

    public Scanner<E> read(String filename) {
        return VarIntByteArraysTool.decodeMulti((byte[])this.getDirectory().read(PathbeanKey.of((String)filename))).map(this::decode);
    }

    public void write(Scanner<E> dtos, Ulid ulid) {
        PathbeanKey key = PathbeanKey.of((String)ulid.value());
        dtos.map(BaseBinaryDto::encodeIndexed).map(VarIntByteArraysTool::encodeOne).then(scanner -> this.getDirectory().writeChunks(key, scanner));
    }

    public Scanner<String> scanKeysAllowUnsorted() {
        return this.getDirectory().scanKeys(Subpath.empty(), new Config().setAllowUnsortedScan(Boolean.valueOf(true))).map(PathbeanKey::getPathAndFile);
    }

    public void delete(String filename) {
        this.getDirectory().delete(PathbeanKey.of((String)filename));
    }

    public void deleteAll() {
        this.getDirectory().deleteAll(Subpath.empty());
    }
}

