/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.IntegerField;
import io.datarouter.model.field.imp.comparable.IntegerFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.service.DatarouterServiceFieldKeys;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

public class ExceptionRecord
extends BaseDatabean<ExceptionRecordKey, ExceptionRecord> {
    private Date created;
    private String serviceName;
    private String serverName;
    private String category;
    private String name;
    private String stackTrace;
    private String type;
    private String appVersion;
    private String exceptionLocation;
    private String methodName;
    private Integer lineNumber;
    private String callOrigin;
    private List<String> additionalAlertRecipients;

    public ExceptionRecord() {
        super((PrimaryKey)new ExceptionRecordKey());
    }

    public ExceptionRecord(ExceptionRecordKey key, long dateMs, String serviceName, String serverName, String category, String name, String stackTrace, String type, String appVersion, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin, List<String> additionalAlertRecipients) {
        super((PrimaryKey)key);
        this.created = new Date(dateMs);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.category = category;
        this.name = name;
        this.stackTrace = stackTrace;
        this.type = type;
        this.appVersion = appVersion;
        this.exceptionLocation = exceptionLocation;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
        this.callOrigin = callOrigin;
        this.additionalAlertRecipients = additionalAlertRecipients;
    }

    public ExceptionRecord(ExceptionRecordDto dto) {
        this(new ExceptionRecordKey(dto.id()), dto.created().getTime(), dto.serviceName(), dto.serverName(), dto.category(), dto.name(), dto.stackTrace(), dto.type(), dto.appVersion(), dto.exceptionLocation(), dto.methodName(), dto.lineNumber(), dto.callOrigin(), dto.additionalAlertRecipients());
    }

    public Supplier<ExceptionRecordKey> getKeySupplier() {
        return ExceptionRecordKey::new;
    }

    public ExceptionRecordDto toDto() {
        return new ExceptionRecordDto(((ExceptionRecordKey)this.getKey()).getId(), this.created, this.serviceName, this.serverName, this.category, this.name, this.stackTrace, this.type, this.appVersion, this.exceptionLocation, this.methodName, this.lineNumber, this.callOrigin, this.additionalAlertRecipients);
    }

    public Date getCreated() {
        return this.created;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getType() {
        return this.type;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getExceptionLocation() {
        return this.exceptionLocation;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getCallOrigin() {
        return this.callOrigin;
    }

    public List<String> getAdditionalAlertRecipients() {
        return this.additionalAlertRecipients;
    }

    public void trimFields() {
        this.trimStackTrace();
    }

    public void trimStackTrace() {
        this.stackTrace = StringTool.trimToSizeAndLog((String)this.stackTrace, (int)500000, (String)"trimmed", (String[])new String[]{"field=stackTrace", "exceptionRecordId=" + ((ExceptionRecordKey)this.getKey()).getId()});
    }

    public static class ExceptionRecordFielder
    extends BaseDatabeanFielder<ExceptionRecordKey, ExceptionRecord> {
        public ExceptionRecordFielder() {
            super(ExceptionRecordKey::new);
        }

        public List<Field<?>> getNonKeyFields(ExceptionRecord databean) {
            return List.of(new DateField(FieldKeys.created, databean.getCreated()), new StringField(DatarouterServiceFieldKeys.serviceName, databean.getServiceName()), new StringField(FieldKeys.serverName, databean.getServerName()), new StringField(FieldKeys.category, databean.getCategory()), new StringField(FieldKeys.name, databean.getName()), new StringField(FieldKeys.stackTrace, databean.getStackTrace()), new StringField(FieldKeys.type, databean.getType()), new StringField(FieldKeys.appVersion, databean.getAppVersion()), new StringField(FieldKeys.exceptionLocation, databean.getExceptionLocation()), new StringField(FieldKeys.methodName, databean.getMethodName()), new IntegerField(FieldKeys.lineNumber, databean.getLineNumber()), new StringField(FieldKeys.callOrigin, databean.getCallOrigin()));
        }
    }

    public static class FieldKeys {
        public static final DateFieldKey created = new DateFieldKey("created");
        public static final StringFieldKey serverName = new StringFieldKey("serverName");
        public static final StringFieldKey category = new StringFieldKey("category");
        public static final StringFieldKey name = new StringFieldKey("name");
        public static final StringFieldKey stackTrace = new StringFieldKey("stackTrace").withSize(0xFFFFFF);
        public static final StringFieldKey type = new StringFieldKey("type");
        public static final StringFieldKey appVersion = new StringFieldKey("appVersion");
        public static final StringFieldKey exceptionLocation = new StringFieldKey("exceptionLocation");
        public static final StringFieldKey methodName = new StringFieldKey("methodName");
        public static final IntegerFieldKey lineNumber = new IntegerFieldKey("lineNumber");
        public static final StringFieldKey callOrigin = new StringFieldKey("callOrigin");
    }
}

