/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.util.number.RandomTool;
import java.time.Instant;
import java.util.List;

public class ExceptionRecordKey
extends BaseRegularPrimaryKey<ExceptionRecordKey> {
    private static final int PADDING = String.valueOf(Long.MAX_VALUE).length();
    private static final String ID_FORMAT = "%d%0" + PADDING + "d";
    private String id;

    public List<Field<?>> getFields() {
        return List.of(new StringField(FieldKeys.id, this.id));
    }

    public ExceptionRecordKey() {
    }

    public ExceptionRecordKey(String id) {
        this.id = id;
    }

    public static ExceptionRecordKey generate() {
        String id = String.format(ID_FORMAT, System.currentTimeMillis(), RandomTool.nextPositiveLong());
        return new ExceptionRecordKey(id);
    }

    public static Instant exceptionIdToInstant(String exceptionId) {
        String timeMs = exceptionId.substring(0, exceptionId.length() - PADDING);
        return Instant.ofEpochMilli(Long.parseLong(timeMs));
    }

    public String getId() {
        return this.id;
    }

    public static class FieldKeys {
        public static final StringFieldKey id = new StringFieldKey("id");
    }
}

