/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.Codec;
import io.datarouter.exception.dto.ExceptionRecordBinaryDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.QueueNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.queue.consumer.BlobQueueConsumer;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantBlobQueueStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;

@Singleton
public class ExceptionRecordQueueDao
extends BaseDao {
    private final BlobQueueStorage.BlobQueueStorageNode<ExceptionRecordBinaryDto> node;

    @Inject
    public ExceptionRecordQueueDao(Datarouter datarouter, ExceptionRecordQueueDaoParams params, QueueNodeFactory queueNodeFactory, EnvironmentName environmentNameSupplier) {
        super(datarouter);
        String namespace = environmentNameSupplier.deprecatedIsProduction() ? "shared" : String.valueOf(environmentNameSupplier.get()) + "-shared";
        this.node = (BlobQueueStorage.BlobQueueStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> queueNodeFactory.createBlobQueue(clientId, "ExceptionRecordBinaryDto", (Codec)BinaryDtoIndexedCodec.of(ExceptionRecordBinaryDto.class)).withNamespace(namespace).withTag(Tag.DATAROUTER).build()).listTo(RedundantBlobQueueStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void combineAndPut(Scanner<ExceptionRecordBinaryDto> dtos) {
        this.node.combineAndPut(dtos);
    }

    public BlobQueueConsumer<ExceptionRecordBinaryDto> getBlobQueueConsumer() {
        return new BlobQueueConsumer(this.node);
    }

    public static class ExceptionRecordQueueDaoParams
    extends BaseRedundantDaoParams {
        public ExceptionRecordQueueDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

