/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.httprecord;

import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.exception.storage.httprecord.BaseHttpRequestRecord;
import io.datarouter.exception.storage.httprecord.HttpRequestRecordKey;
import io.datarouter.gson.GsonTool;
import io.datarouter.instrumentation.exception.HttpRequestRecordDto;
import io.datarouter.instrumentation.trace.W3TraceContext;
import io.datarouter.types.Ulid;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.monitoring.exception.ExceptionAndHttpRequestDto;
import io.datarouter.web.util.RequestAttributeKey;
import io.datarouter.web.util.RequestAttributeTool;
import io.datarouter.web.util.http.RecordedHttpHeaders;
import io.datarouter.web.util.http.RequestTool;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestRecord
extends BaseHttpRequestRecord<HttpRequestRecordKey, HttpRequestRecord> {
    public HttpRequestRecord() {
        super(new HttpRequestRecordKey());
    }

    public HttpRequestRecord(String exceptionRecordId, Optional<W3TraceContext> traceContext, HttpServletRequest request, String sessionRoles, String userToken, boolean omitPayload) {
        this(RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.REQUEST_RECEIVED_AT).orElse(new Date()), exceptionRecordId, traceContext.map(W3TraceContext::getTraceId).orElse(null), traceContext.map(W3TraceContext::getParentId).orElse(null), request.getMethod(), GsonTool.withUnregisteredEnums().toJson((Object)request.getParameterMap()), request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath(), HttpRequestRecord.getRequestPath(request), request.getQueryString(), omitPayload ? HttpRequestRecordDto.CONFIDENTIALITY_MSG_BYTES : RequestTool.tryGetBodyAsByteArray((ServletRequest)request), RequestTool.getIpAddress((HttpServletRequest)request), sessionRoles, userToken, new RecordedHttpHeaders(request));
    }

    private static String getRequestPath(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        if (requestUri == null) {
            return "";
        }
        return requestUri.substring(StringTool.nullSafe((String)request.getContextPath()).length());
    }

    public HttpRequestRecord(Date receivedAt, String exceptionRecordId, String traceId, String parentId, String httpMethod, String httpParams, String protocol, String hostname, int port, String contextPath, String path, String queryString, byte[] binaryBody, String ip, String sessionRoles, String userToken, RecordedHttpHeaders headersWrapper) {
        super(new HttpRequestRecordKey(new Ulid()), receivedAt, exceptionRecordId, traceId, parentId, httpMethod, httpParams, protocol, hostname, port, contextPath, path, queryString, binaryBody, ip, sessionRoles, userToken, headersWrapper);
    }

    public HttpRequestRecord(ExceptionAndHttpRequestDto exceptionDto, String exceptionRecordId) {
        super(new HttpRequestRecordKey(new Ulid()), exceptionDto, exceptionRecordId);
    }

    public HttpRequestRecordDto toDto() {
        return new HttpRequestRecordDto(((HttpRequestRecordKey)this.getKey()).getId().value(), this.getCreated(), this.getReceivedAt(), this.getDuration(), this.getExceptionRecordId(), this.getTraceId(), this.getParentId(), this.getHttpMethod(), this.getHttpParams(), this.getProtocol(), this.getHostname(), this.getPort(), this.getContextPath(), this.getPath(), this.getQueryString(), this.getBinaryBody(), this.getIp(), this.getUserRoles(), this.getUserToken(), this.getAcceptCharset(), this.getAcceptEncoding(), this.getAcceptLanguage(), this.getAccept(), this.getCacheControl(), this.getConnection(), this.getContentEncoding(), this.getContentLanguage(), this.getContentLength(), this.getContentType(), this.getCookie(), this.getDnt(), this.getHost(), this.getIfModifiedSince(), this.getOrigin(), this.getPragma(), this.getReferer(), this.getUserAgent(), this.getxForwardedFor(), this.getxRequestedWith(), this.getOtherHeaders());
    }

    public static HttpRequestRecord createEmptyForTesting() {
        return new HttpRequestRecord(null, null, null, null, null, null, null, null, 0, null, null, null, null, null, null, null, new RecordedHttpHeaders(null));
    }

    public Supplier<HttpRequestRecordKey> getKeySupplier() {
        return HttpRequestRecordKey::new;
    }

    public ExceptionRecordKey getExceptionRecordKey() {
        return new ExceptionRecordKey(this.getExceptionRecordId());
    }

    public static class HttpRequestRecordFielder
    extends BaseHttpRequestRecord.BaseHttpRequestRecordFielder<HttpRequestRecordKey, HttpRequestRecord> {
        public HttpRequestRecordFielder() {
            super(HttpRequestRecordKey::new);
        }
    }
}

